/*
 * Decompiled with CFR 0.152.
 */
package org.jhades.utils;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.jhades.utils.StdOutLogger;

public final class ZipUtils {
    private static final StdOutLogger logger = StdOutLogger.getLogger();

    private ZipUtils() {
        throw new UnsupportedOperationException("Utility classes cannot be instantiated.");
    }

    public static void unzip(String zipFilename, String destDirname) throws IOException {
        ZipUtils.unzip(zipFilename, destDirname);
    }

    public static void unzip(String zipFilename, String destDirname, final UnzipProgressListener progressListener) throws IOException {
        final Path destDir = Paths.get(destDirname, new String[0]);
        if (Files.notExists(destDir, new LinkOption[0])) {
            logger.debug(destDir + " does not exist. Creating...");
            Files.createDirectories(destDir, new FileAttribute[0]);
        }
        try (FileSystem zipFileSystem = ZipUtils.createZipFileSystem(zipFilename, false);){
            Path root = zipFileSystem.getPath("/", new String[0]);
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (progressListener != null) {
                        progressListener.onBeginFileExtract(file.toString());
                    }
                    Path destFile = Paths.get(destDir.toString(), file.toString());
                    logger.debug("Extracting file " + file + " to " + destFile + "\n");
                    Files.copy(file, destFile, StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path dirToCreate = Paths.get(destDir.toString(), dir.toString());
                    if (Files.notExists(dirToCreate, new LinkOption[0])) {
                        logger.debug("Creating directory " + dirToCreate + "\n");
                        Files.createDirectory(dirToCreate, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static FileSystem createZipFileSystem(String zipFilename, boolean create) throws IOException {
        Path path = Paths.get(zipFilename, new String[0]);
        URI uri = URI.create("jar:file:" + path.toUri().getPath());
        HashMap<String, String> env = new HashMap<String, String>();
        if (create) {
            env.put("create", "true");
        }
        return FileSystems.newFileSystem(uri, env);
    }

    public static interface UnzipProgressListener {
        public void onBeginFileExtract(String var1);
    }
}

