/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jooq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.Annotations;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisMethodChecker;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.lang.reflect.Method;
import java.util.List;
import org.jinq.jooq.transform.MetamodelUtil;

final class MethodChecker
implements PathAnalysisMethodChecker {
    MetamodelUtil metamodel;

    MethodChecker(MetamodelUtil metamodel) {
        this.metamodel = metamodel;
    }

    public boolean isStaticMethodSafe(MethodSignature m) {
        return this.metamodel.isSafeStaticMethod(m);
    }

    public boolean isMethodSafe(MethodSignature m, TypedValue base, List<TypedValue> args) {
        if (this.metamodel.isSafeMethod(m)) {
            return true;
        }
        try {
            Method reflectedMethod = Annotations.asmMethodSignatureToReflectionMethod((MethodSignature)m);
            return Annotations.methodHasSomeAnnotations((Method)reflectedMethod, this.metamodel.getSafeMethodAnnotations());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
            return false;
        }
    }
}

