/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jooq.querygen;

import java.lang.reflect.Constructor;
import org.jinq.jooq.querygen.RowReader;
import org.jinq.jooq.querygen.SimpleRowReader;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;

public class TableRowReader<T extends Record>
implements RowReader<T> {
    private Constructor<? extends T> constructor;
    private Table<T> table;

    public TableRowReader(Table<T> table) {
        this.table = table;
        try {
            this.constructor = table.getRecordType().getDeclaredConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot find constructor for class " + table.getRecordType().getName());
        }
    }

    @Override
    public T readResult(Record record) {
        return this.readResult(record, 0);
    }

    @Override
    public T readResult(Record record, int offset) {
        Record toReturn;
        try {
            toReturn = (Record)this.constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot construct class " + this.table.getRecordType().getName());
        }
        Field[] fields = this.table.fields();
        for (int idx = 0; idx < fields.length; ++idx) {
            Field f = fields[idx];
            this.copyValueIntoRecord(toReturn, record, f, idx);
        }
        return (T)toReturn;
    }

    private <K> void copyValueIntoRecord(T outputRecord, Record inputRecord, Field<K> field, int idx) {
        outputRecord.setValue(field, inputRecord.getValue(idx, field.getConverter()));
    }

    @Override
    public int getNumColumns() {
        return this.table.fields().length;
    }

    public <U> RowReader<U> getReaderForField(Field<?> field) {
        Field[] fields = this.table.fields();
        for (int idx = 0; idx < fields.length; ++idx) {
            Field f = fields[idx];
            if (f != field) continue;
            return new SimpleRowReader();
        }
        throw new IllegalArgumentException("Unknown field");
    }

    public int getIndexForField(Field<?> field) {
        Field[] fields = this.table.fields();
        int colIndex = 0;
        for (int idx = 0; idx < fields.length; ++idx) {
            Field f = fields[idx];
            if (f == field) {
                return colIndex;
            }
            colIndex += this.getReaderForField(field).getNumColumns();
        }
        throw new IllegalArgumentException("Unknown field");
    }
}

