/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jooq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jooq.Field;
import org.jooq.Schema;
import org.jooq.Table;
import org.objectweb.asm.Type;

public class MetamodelUtil {
    private final Set<Class<?>> safeMethodAnnotations = new HashSet();
    final Map<MethodSignature, Field<?>> fieldMethods;
    private final Set<MethodSignature> safeMethods;
    private final Set<MethodSignature> safeStaticMethods;
    public static final Map<MethodSignature, Integer> TUPLE_ACCESSORS = new HashMap<MethodSignature, Integer>();

    public MetamodelUtil(Schema schema) {
        this.safeMethodAnnotations.addAll(TransformationClassAnalyzer.SafeMethodAnnotations);
        this.safeMethods = new HashSet<MethodSignature>();
        this.safeMethods.addAll(TransformationClassAnalyzer.KnownSafeMethods);
        this.safeMethods.add(TransformationClassAnalyzer.integerIntValue);
        this.safeMethods.add(TransformationClassAnalyzer.doubleDoubleValue);
        this.safeStaticMethods = new HashSet<MethodSignature>();
        this.safeStaticMethods.addAll(TransformationClassAnalyzer.KnownSafeStaticMethods);
        this.safeStaticMethods.add(TransformationClassAnalyzer.integerValueOf);
        this.safeStaticMethods.add(TransformationClassAnalyzer.doubleValueOf);
        this.fieldMethods = new HashMap();
        this.findMetamodelGetters(schema);
        this.safeMethods.addAll(this.fieldMethods.keySet());
    }

    private void findMetamodelGetters(Schema schema) {
        for (Table table : schema.getTables()) {
            String recordClassName = Type.getInternalName((Class)table.getRecordType());
            for (Field field : table.fields()) {
                String name = field.getName();
                String getterName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
                MethodSignature methodSig = new MethodSignature(recordClassName, getterName, Type.getMethodDescriptor((Type)Type.getType((Class)field.getType()), (Type[])new Type[0]));
                this.fieldMethods.put(methodSig, field);
            }
        }
    }

    public Set<Class<?>> getSafeMethodAnnotations() {
        return this.safeMethodAnnotations;
    }

    public boolean isSafeMethod(MethodSignature m) {
        return this.safeMethods.contains(m);
    }

    public boolean isSafeStaticMethod(MethodSignature m) {
        return this.safeStaticMethods.contains(m);
    }

    public boolean isFieldGetterMethod(MethodSignature sig) {
        return this.fieldMethods.containsKey(sig);
    }

    public Field<?> fieldMethodToField(MethodSignature sig) {
        return this.fieldMethods.get(sig);
    }

    static {
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.pairGetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple3GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple4GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple5GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple6GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple7GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetOne, 1);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetTwo, 2);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetThree, 3);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFour, 4);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetFive, 5);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSix, 6);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetSeven, 7);
        TUPLE_ACCESSORS.put(TransformationClassAnalyzer.tuple8GetEight, 8);
    }
}

