/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jooq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jooq.querygen.ColumnExpressions;
import org.jinq.jooq.querygen.RowReader;
import org.jinq.jooq.querygen.SimpleRowReader;
import org.jinq.jooq.querygen.TableRowReader;
import org.jinq.jooq.querygen.TupleRowReader;
import org.jinq.jooq.transform.MetamodelUtil;
import org.jinq.jooq.transform.SymbExArgumentHandler;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.impl.DSL;

public class SymbExToColumns
extends TypedValueVisitor<Void, ColumnExpressions<?>, TypedValueVisitorException> {
    final MetamodelUtil metamodel;
    final SymbExArgumentHandler argHandler;

    SymbExToColumns(MetamodelUtil metamodel, SymbExArgumentHandler argumentHandler) {
        this.metamodel = metamodel;
        this.argHandler = argumentHandler;
    }

    ColumnExpressions<?> transform(TypedValue val) throws TypedValueVisitorException {
        return (ColumnExpressions)val.visit((TypedValueVisitor)this, null);
    }

    public ColumnExpressions<?> defaultValue(TypedValue val, Void in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled symbolic execution operation: " + val);
    }

    public ColumnExpressions<?> argValue(TypedValue.ArgValue val, Void in) throws TypedValueVisitorException {
        int index = val.getIndex();
        return this.argHandler.handleArg(index, val.getType());
    }

    public ColumnExpressions<?> booleanConstantValue(ConstantValue.BooleanConstant val, Void in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), (QueryPart)DSL.val((Object)val.val));
    }

    public ColumnExpressions<?> integerConstantValue(ConstantValue.IntegerConstant val, Void in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), (QueryPart)DSL.val((Object)val.val));
    }

    public ColumnExpressions<?> stringConstantValue(ConstantValue.StringConstant val, Void in) throws TypedValueVisitorException {
        return ColumnExpressions.singleColumn(new SimpleRowReader(), (QueryPart)DSL.val((Object)val.val));
    }

    public ColumnExpressions<?> castValue(TypedValue.CastValue val, Void in) throws TypedValueVisitorException {
        return (ColumnExpressions)val.operand.visit((TypedValueVisitor)this, (Object)in);
    }

    public ColumnExpressions<?> mathOpValue(TypedValue.MathOpValue val, Void in) throws TypedValueVisitorException {
        Field resultField;
        ColumnExpressions left = (ColumnExpressions)val.left.visit((TypedValueVisitor)this, (Object)in);
        ColumnExpressions right = (ColumnExpressions)val.right.visit((TypedValueVisitor)this, (Object)in);
        Field leftField = (Field)left.getOnlyColumn();
        Field rightField = (Field)right.getOnlyColumn();
        switch (val.op) {
            case minus: {
                resultField = leftField.minus(rightField);
                break;
            }
            case plus: {
                resultField = leftField.plus(rightField);
                break;
            }
            case mul: {
                resultField = leftField.mul(rightField);
                break;
            }
            default: {
                throw new TypedValueVisitorException("Unknown math operator");
            }
        }
        return ColumnExpressions.singleColumn(left.reader, (QueryPart)resultField);
    }

    public ColumnExpressions<?> comparisonOpValue(TypedValue.ComparisonValue val, Void in) throws TypedValueVisitorException {
        ColumnExpressions left = (ColumnExpressions)val.left.visit((TypedValueVisitor)this, (Object)in);
        ColumnExpressions right = (ColumnExpressions)val.right.visit((TypedValueVisitor)this, (Object)in);
        if (!left.isSingleColumn() || !right.isSingleColumn()) {
            throw new TypedValueVisitorException("Do not know how to compare multiple columns together");
        }
        Field leftField = (Field)left.getOnlyColumn();
        Field rightField = (Field)right.getOnlyColumn();
        Condition result = null;
        switch (val.compOp) {
            case eq: {
                result = leftField.eq(rightField);
                break;
            }
            case ge: {
                result = leftField.ge(rightField);
                break;
            }
            case gt: {
                result = leftField.gt(rightField);
                break;
            }
            case le: {
                result = leftField.le(rightField);
                break;
            }
            case lt: {
                result = leftField.lt(rightField);
                break;
            }
            case ne: {
                result = leftField.ne(rightField);
                break;
            }
            default: {
                throw new TypedValueVisitorException("Unknown comparison operator");
            }
        }
        return ColumnExpressions.singleColumn(left.reader, (QueryPart)result);
    }

    public ColumnExpressions<?> virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, Void in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (TransformationClassAnalyzer.newPair.equals((Object)sig) || TransformationClassAnalyzer.newTuple3.equals((Object)sig) || TransformationClassAnalyzer.newTuple4.equals((Object)sig) || TransformationClassAnalyzer.newTuple5.equals((Object)sig) || TransformationClassAnalyzer.newTuple6.equals((Object)sig) || TransformationClassAnalyzer.newTuple7.equals((Object)sig) || TransformationClassAnalyzer.newTuple8.equals((Object)sig)) {
            ColumnExpressions[] vals = new ColumnExpressions[val.args.size()];
            for (int n = 0; n < vals.length; ++n) {
                vals[n] = (ColumnExpressions)((TypedValue)val.args.get(n)).visit((TypedValueVisitor)this, (Object)in);
            }
            RowReader[] valReaders = new RowReader[vals.length];
            for (int n = 0; n < vals.length; ++n) {
                valReaders[n] = vals[n].reader;
            }
            ColumnExpressions toReturn = new ColumnExpressions(TupleRowReader.createReaderForTuple(sig.owner, valReaders));
            for (int n = 0; n < vals.length; ++n) {
                toReturn.columns.addAll(vals[n].columns);
            }
            return toReturn;
        }
        if (this.metamodel.isFieldGetterMethod(sig)) {
            Field<?> field = this.metamodel.fieldMethodToField(sig);
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)in);
            if (!(base.reader instanceof TableRowReader)) {
                throw new TypedValueVisitorException("Expecting a table");
            }
            TableRowReader tableReader = (TableRowReader)base.reader;
            RowReader columnReader = tableReader.getReaderForField(field);
            ColumnExpressions newColumns = new ColumnExpressions(columnReader);
            int idx = tableReader.getIndexForField(field);
            for (int n = 0; n < columnReader.getNumColumns(); ++n) {
                newColumns.columns.add(base.columns.get(n + idx));
            }
            return newColumns;
        }
        if (MetamodelUtil.TUPLE_ACCESSORS.containsKey(sig)) {
            int idx = MetamodelUtil.TUPLE_ACCESSORS.get(sig) - 1;
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)in);
            RowReader<?> subreader = ((TupleRowReader)base.reader).getReaderForIndex(idx);
            ColumnExpressions toReturn = new ColumnExpressions(subreader);
            int baseOffset = ((TupleRowReader)base.reader).getColumnForIndex(idx);
            for (int n = 0; n < subreader.getNumColumns(); ++n) {
                toReturn.columns.add(base.columns.get(n + baseOffset));
            }
            return toReturn;
        }
        if (sig.equals((Object)TransformationClassAnalyzer.integerIntValue) || sig.equals((Object)TransformationClassAnalyzer.doubleDoubleValue)) {
            ColumnExpressions base = (ColumnExpressions)val.base.visit((TypedValueVisitor)this, (Object)in);
            return base;
        }
        return (ColumnExpressions)super.virtualMethodCallValue(val, (Object)in);
    }

    public ColumnExpressions<?> staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, Void in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (sig.equals((Object)TransformationClassAnalyzer.integerValueOf) || sig.equals((Object)TransformationClassAnalyzer.doubleValueOf)) {
            ColumnExpressions base = (ColumnExpressions)((TypedValue)val.args.get(0)).visit((TypedValueVisitor)this, (Object)in);
            return base;
        }
        return (ColumnExpressions)super.staticMethodCallValue(val, (Object)in);
    }
}

