/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jooq.transform;

import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jinq.jooq.querygen.ColumnExpressions;
import org.jinq.jooq.querygen.SimpleRowReader;
import org.jinq.jooq.querygen.TableRowReader;
import org.jinq.jooq.transform.LambdaInfo;
import org.jinq.jooq.transform.SymbExArgumentHandler;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.objectweb.asm.Type;

public class SelectFromWhereLambdaArgumentHandler
implements SymbExArgumentHandler {
    List<Table<?>> fromList;
    LambdaInfo lambda;
    final int numLambdaCapturedArgs;
    public static final Set<Type> ALLOWED_QUERY_PARAMETER_TYPES = new HashSet<Type>();

    public SelectFromWhereLambdaArgumentHandler(LambdaInfo lambda, List<Table<?>> fromTables) {
        this.lambda = lambda;
        this.numLambdaCapturedArgs = lambda.serializedLambda.capturedArgs.length;
        this.fromList = fromTables;
    }

    @Override
    public ColumnExpressions<?> handleArg(int argIndex, Type argType) throws TypedValueVisitorException {
        if (argIndex < this.numLambdaCapturedArgs) {
            if (!ALLOWED_QUERY_PARAMETER_TYPES.contains(argType)) {
                throw new TypedValueVisitorException("Accessing a field with unhandled type");
            }
            return ColumnExpressions.singleColumn(new SimpleRowReader(), (QueryPart)DSL.val((Object)this.lambda.getCapturedArg(argIndex)));
        }
        Table<?> table = this.fromList.get(argIndex - this.numLambdaCapturedArgs);
        ColumnExpressions columns = new ColumnExpressions(new TableRowReader(table));
        for (Field field : table.fields()) {
            columns.columns.add((QueryPart)field);
        }
        return columns;
    }

    static {
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.INT_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.DOUBLE_TYPE);
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Integer"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/Double"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/lang/String"));
        ALLOWED_QUERY_PARAMETER_TYPES.add(Type.getObjectType((String)"java/sql/Date"));
    }
}

