/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jooq.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.Collections;
import java.util.List;
import org.jinq.jooq.querygen.ColumnExpressions;
import org.jinq.jooq.transform.LambdaInfo;
import org.jinq.jooq.transform.MetamodelUtil;
import org.jinq.jooq.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jooq.transform.SymbExToColumns;
import org.jooq.Condition;
import org.jooq.QueryPart;
import org.jooq.Table;

public class WhereTransform {
    MetamodelUtil metamodel;
    LambdaInfo where;

    public WhereTransform(MetamodelUtil metamodel, LambdaInfo where) {
        this.metamodel = metamodel;
        this.where = where;
    }

    public Condition apply(List<Table<?>> fromList) {
        try {
            SymbExToColumns translator = new SymbExToColumns(this.metamodel, new SelectFromWhereLambdaArgumentHandler(this.where, fromList));
            Condition methodExpr = null;
            for (int n = 0; n < this.where.symbolicAnalysis.paths.size(); ++n) {
                PathAnalysis path = (PathAnalysis)this.where.symbolicAnalysis.paths.get(n);
                TypedValue returnVal = PathAnalysisSimplifier.simplifyBoolean((TypedValue)path.getReturnValue(), Collections.emptyMap());
                ColumnExpressions<?> returnColumns = translator.transform(returnVal);
                if (!returnColumns.isSingleColumn()) {
                    throw new IllegalArgumentException("Where lambda should only return a single column of data");
                }
                QueryPart returnExpr = returnColumns.getOnlyColumn();
                if (returnVal instanceof ConstantValue.BooleanConstant) {
                    if (!((ConstantValue.BooleanConstant)returnVal).val) continue;
                    returnExpr = null;
                }
                Condition conditionExpr = null;
                for (TypedValue cmp : path.getConditions()) {
                    ColumnExpressions<?> col = translator.transform(cmp);
                    if (!col.isSingleColumn()) {
                        throw new IllegalArgumentException("Expecting a single column");
                    }
                    Condition expr = (Condition)col.getOnlyColumn();
                    if (conditionExpr != null) {
                        conditionExpr = conditionExpr.and(expr);
                        continue;
                    }
                    conditionExpr = expr;
                }
                Condition pathExpr = (Condition)returnExpr;
                if (conditionExpr != null) {
                    pathExpr = pathExpr == null ? conditionExpr : pathExpr.and(conditionExpr);
                }
                methodExpr = methodExpr != null ? methodExpr.or(pathExpr) : pathExpr;
            }
            return methodExpr;
        }
        catch (TypedValueVisitorException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Could not create query from lambda", e);
        }
    }
}

