/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.tools;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class EntityGenerator {
    public static void main(String[] args) {
        assert (args.length >= 2);
        String filename = args[0];
        String outputPath = args[1];
        String entityListString = EntityGenerator.getXSLTResultString(filename, "shared/entity_list.xslt");
        String[] entityList = entityListString.trim().split("\\s+");
        String packageName = EntityGenerator.getXSLTResultString(filename, "shared/entity_package.xslt");
        packageName = packageName.trim();
        String packagePath = outputPath + "/" + packageName.replace('.', '/');
        new File(packagePath).mkdirs();
        String variant = "sql/";
        for (String entity : entityList) {
            EntityGenerator.createEntity(entity, packageName, filename, outputPath, variant);
        }
        EntityGenerator.createEntityManager(packageName, filename, outputPath, variant);
        EntityGenerator.createDBManager(packageName, filename, outputPath, variant);
    }

    static void createEntityManager(String packageName, String descriptionFile, String outputPath, String variant) {
        outputPath = outputPath + "/" + packageName.replace('.', '/');
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("package", packageName);
        EntityGenerator.applyXSLT(outputPath + "/EntityManager.java", descriptionFile, variant + "create_entity_manager.xslt", params);
    }

    static void createDBManager(String packageName, String descriptionFile, String outputPath, String variant) {
        outputPath = outputPath + "/" + packageName.replace('.', '/');
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("package", packageName);
        EntityGenerator.applyXSLT(outputPath + "/DBManager.java", descriptionFile, variant + "create_db_manager.xslt", params);
    }

    static void createEntity(String entity, String packageName, String descriptionFile, String outputPath, String variant) {
        outputPath = outputPath + "/" + packageName.replace('.', '/');
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("entity", entity);
        params.put("package", packageName);
        EntityGenerator.applyXSLT(outputPath + "/" + entity + ".java", descriptionFile, variant + "create_entity.xslt", params);
    }

    public static String getXSLTResultString(String xmlFile, String xsltFile) {
        StringWriter stringStream = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            Document document = factory.newDocumentBuilder().parse(new File(xmlFile));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(new ClassLoaderURIResolver());
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(EntityGenerator.getResource(xsltFile), EntityGenerator.getResourceSystemId(xsltFile)));
            transformer.transform(new DOMSource(document), new StreamResult(stringStream));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stringStream.toString();
    }

    private static String getResourceSystemId(String file) {
        return new EntityGenerator().getClass().getClassLoader().getResource(file).toString();
    }

    private static InputStream getResource(String file) {
        return new EntityGenerator().getClass().getClassLoader().getResourceAsStream(file);
    }

    public static void applyXSLT(String destFile, String xmlFile, String xsltFile, Map params) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            Document document = factory.newDocumentBuilder().parse(new File(xmlFile));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setURIResolver(new ClassLoaderURIResolver());
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(EntityGenerator.getResource(xsltFile), EntityGenerator.getResourceSystemId(xsltFile)));
            if (params != null) {
                for (Map.Entry e : params.entrySet()) {
                    transformer.setParameter((String)e.getKey(), (String)e.getValue());
                }
            }
            transformer.transform(new DOMSource(document), new StreamResult(new File(destFile)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class ClassLoaderURIResolver
    implements URIResolver {
        ClassLoaderURIResolver() {
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            if (href.startsWith("../")) {
                href = href.substring(3);
            }
            return new StreamSource(EntityGenerator.getResource(href));
        }
    }
}

