/*
 * Decompiled with CFR 0.152.
 */
package org.jire.kotmem;

import com.sun.jna.Platform;
import com.sun.jna.ptr.IntByReference;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jire.kotmem.Process;
import org.jire.kotmem.linux.LinuxProcess;
import org.jire.kotmem.mac.MacProcess;
import org.jire.kotmem.mac.mac;
import org.jire.kotmem.win32.Win32;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0087\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bH\u0087\nJ\u0011\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0087\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bH\u0087\n\u00a8\u0006\f"}, d2={"Lorg/jire/kotmem/Processes;", "", "()V", "get", "Lorg/jire/kotmem/Process;", "processID", "", "action", "Lkotlin/Function1;", "", "processName", "", "kotmem-compileKotlin"})
public final class Processes {
    public static final Processes INSTANCE;

    @JvmStatic
    @NotNull
    public static final Process get(int processID) {
        Process process;
        if (Platform.isWindows()) {
            process = Win32.openProcess$default(processID, 0, 2, null);
        } else if (Platform.isLinux()) {
            process = new LinuxProcess(processID);
        } else if (Platform.isMac()) {
            IntByReference out = new IntByReference();
            if (mac.task_for_pid(mac.mach_task_self(), processID, out) != 0) {
                throw (Throwable)new IllegalStateException("Failed to find mach task port for process");
            }
            process = new MacProcess(processID, out.getValue());
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported platform or not enough privilege");
        }
        return process;
    }

    @JvmStatic
    @NotNull
    public static final Process get(int processID, @NotNull Function1<? super Process, Unit> action) {
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Process process = Processes.get(processID);
        action.invoke((Object)process);
        return process;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Process get(@NotNull String processName) {
        Process process;
        Intrinsics.checkParameterIsNotNull((Object)processName, (String)"processName");
        if (Platform.isWindows()) {
            process = Processes.get(Win32.processIDByName(processName));
        } else if (Platform.isLinux() || Platform.isMac()) {
            void elements$iv;
            String[] stringArray = new String[]{"bash", "-c", "ps -A | grep -m1 " + "\"" + processName + "\"" + " | awk '{print " + "$" + "1}'"};
            Runtime runtime = Runtime.getRuntime();
            Object[] objectArray = (Object[])elements$iv;
            java.lang.Process search = runtime.exec((String[])objectArray);
            process = Processes.get(new Scanner(search.getInputStream()).nextInt());
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported platform");
        }
        return process;
    }

    @JvmStatic
    @NotNull
    public static final Process get(@NotNull String processName, @NotNull Function1<? super Process, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)processName, (String)"processName");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Process process = Processes.get(processName);
        action.invoke((Object)process);
        return process;
    }

    private Processes() {
        INSTANCE = this;
    }

    static {
        new Processes();
    }
}

