/*
 * Decompiled with CFR 0.152.
 */
package org.jire.kotmem.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jire.kotmem.NativeBuffer;
import org.jire.kotmem.win32.Kernel32;
import org.jire.kotmem.win32.Win32Process;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001\u001a&\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"PROCESS_FULL_ACCESS", "", "PROCESS_QUERY_INFORMATION", "PROCESS_VM_OPERATION", "PROCESS_VM_READ", "PROCESS_VM_WRITE", "openProcess", "Lorg/jire/kotmem/win32/Win32Process;", "processID", "accessFlags", "processIDByName", "processName", "", "readProcessMemory", "", "process", "address", "Lcom/sun/jna/Pointer;", "buffer", "Lorg/jire/kotmem/NativeBuffer;", "bytes", "writeProcessMemory", "kotmem-compileKotlin"})
@JvmName(name="Win32")
public final class Win32 {
    public static final int PROCESS_QUERY_INFORMATION = 1024;
    public static final int PROCESS_VM_READ = 16;
    public static final int PROCESS_VM_WRITE = 32;
    public static final int PROCESS_VM_OPERATION = 8;
    public static final int PROCESS_FULL_ACCESS = 1080;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int processIDByName(@NotNull String processName) {
        Intrinsics.checkParameterIsNotNull((Object)processName, (String)"processName");
        WinDef.DWORD dWORD = Tlhelp32.TH32CS_SNAPALL;
        Intrinsics.checkExpressionValueIsNotNull((Object)dWORD, (String)"Tlhelp32.TH32CS_SNAPALL");
        WinNT.HANDLE snapshot = Kernel32.CreateToolhelp32Snapshot(dWORD, 0);
        Tlhelp32.PROCESSENTRY32.ByReference entry = new Tlhelp32.PROCESSENTRY32.ByReference();
        try {
            while (Kernel32.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)entry)) {
                String entryName = Native.toString((char[])entry.szExeFile);
                if (!processName.equals(entryName)) continue;
                int n = entry.th32ProcessID.intValue();
                return n;
            }
            throw (Throwable)new IllegalStateException("Could not find process ID of " + "\"" + processName + "\"");
        }
        finally {
            Kernel32.CloseHandle(snapshot);
        }
    }

    @NotNull
    public static final Win32Process openProcess(int processID, int accessFlags) {
        return new Win32Process(processID, Kernel32.OpenProcess(accessFlags, true, processID));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Win32Process openProcess$default(int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openProcess");
        }
        if ((n3 & 2) != 0) {
            n2 = PROCESS_FULL_ACCESS;
        }
        return Win32.openProcess(n, n2);
    }

    public static final boolean readProcessMemory(@NotNull Win32Process process, @NotNull Pointer address, @NotNull NativeBuffer buffer2, int bytes) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)((Object)buffer2), (String)"buffer");
        Pointer pointer2 = process.getHandle().getPointer();
        Intrinsics.checkExpressionValueIsNotNull((Object)pointer2, (String)"process.handle.pointer");
        return Kernel32.ReadProcessMemory(pointer2, address, buffer2, bytes, 0) > (long)0;
    }

    public static final boolean writeProcessMemory(@NotNull Win32Process process, @NotNull Pointer address, @NotNull NativeBuffer buffer2, int bytes) {
        Intrinsics.checkParameterIsNotNull((Object)process, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        Intrinsics.checkParameterIsNotNull((Object)((Object)buffer2), (String)"buffer");
        Pointer pointer2 = process.getHandle().getPointer();
        Intrinsics.checkExpressionValueIsNotNull((Object)pointer2, (String)"process.handle.pointer");
        return Kernel32.WriteProcessMemory(pointer2, address, buffer2, bytes, 0) > (long)0;
    }
}

