/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.test.concurrent;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.test.concurrent.EmptyCompletableFuture;
import org.jitsi.test.concurrent.Job;
import org.jitsi.test.concurrent.JobsTimeline;
import org.jitsi.test.time.FakeClock;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nJ\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/test/concurrent/FakeExecutorService;", "Ljava/util/concurrent/ExecutorService;", "()V", "clock", "Lorg/jitsi/test/time/FakeClock;", "getClock", "()Lorg/jitsi/test/time/FakeClock;", "jobs", "Lorg/jitsi/test/concurrent/JobsTimeline;", "execute", "", "command", "Ljava/lang/Runnable;", "runAll", "runOne", "submit", "Ljava/util/concurrent/Future;", "task", "jicoco-test-kotlin"})
public abstract class FakeExecutorService
implements ExecutorService {
    @NotNull
    private JobsTimeline jobs = new JobsTimeline();
    @NotNull
    private final FakeClock clock = new FakeClock(false, null, 3, null);

    @NotNull
    public final FakeClock getClock() {
        return this.clock;
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.jobs.add(new Job(command, this.clock.instant()));
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Job job = new Job(task, this.clock.instant());
        this.jobs.add(job);
        return new EmptyCompletableFuture((Function0<Unit>)((Function0)new Function0<Unit>(job){
            final /* synthetic */ Job $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        }));
    }

    public final void runOne() {
        Collection collection = this.jobs;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Object e = this.jobs.remove(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"jobs.removeAt(0)");
            Job job = (Job)e;
            if (!job.getCancelled()) {
                job.run();
            } else {
                this.runOne();
            }
        }
    }

    public final void runAll() {
        while (true) {
            Collection collection = this.jobs;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            this.runOne();
        }
    }
}

