/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.test.concurrent;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.test.concurrent.EmptyFuture;
import org.jitsi.test.concurrent.FixedDelayJob;
import org.jitsi.test.concurrent.FixedRateJob;
import org.jitsi.test.concurrent.Job;
import org.jitsi.test.concurrent.JobsTimeline;
import org.jitsi.test.concurrent.RecurringJob;
import org.jitsi.test.time.FakeClock;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J,\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/test/concurrent/FakeScheduledExecutorService;", "Ljava/util/concurrent/ScheduledExecutorService;", "()V", "clock", "Lorg/jitsi/test/time/FakeClock;", "getClock", "()Lorg/jitsi/test/time/FakeClock;", "jobs", "Lorg/jitsi/test/concurrent/JobsTimeline;", "numPendingJobs", "", "run", "", "runOne", "runUntil", "endTime", "Ljava/time/Instant;", "schedule", "Ljava/util/concurrent/ScheduledFuture;", "command", "Ljava/lang/Runnable;", "delay", "", "unit", "Ljava/util/concurrent/TimeUnit;", "scheduleAtFixedRate", "initialDelay", "period", "scheduleWithFixedDelay", "jicoco-test-kotlin"})
public abstract class FakeScheduledExecutorService
implements ScheduledExecutorService {
    @NotNull
    private JobsTimeline jobs = new JobsTimeline();
    @NotNull
    private final FakeClock clock = new FakeClock(false, null, 3, null);

    @NotNull
    public final FakeClock getClock() {
        return this.clock;
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleAtFixedRate(@NotNull Runnable command, long initialDelay, long period, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Instant nextRunTime = this.clock.instant().plus(Duration.ofMillis(unit.toMillis(initialDelay)));
        Intrinsics.checkNotNullExpressionValue((Object)nextRunTime, (String)"nextRunTime");
        Duration duration = Duration.ofMillis(unit.toMillis(period));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(unit.toMillis(period))");
        FixedRateJob job = new FixedRateJob(command, nextRunTime, duration);
        this.jobs.add(job);
        return new EmptyFuture((Function0<Unit>)((Function0)new Function0<Unit>(job){
            final /* synthetic */ FixedRateJob $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        }));
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(@NotNull Runnable command, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Instant nextRunTime = this.clock.instant().plus(Duration.ofNanos(unit.toNanos(delay)));
        Intrinsics.checkNotNullExpressionValue((Object)nextRunTime, (String)"nextRunTime");
        Job job = new Job(command, nextRunTime);
        this.jobs.add(job);
        return new EmptyFuture((Function0<Unit>)((Function0)new Function0<Unit>(job){
            final /* synthetic */ Job $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        }));
    }

    @Override
    @NotNull
    public ScheduledFuture<?> scheduleWithFixedDelay(@NotNull Runnable command, long initialDelay, long delay, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Instant nextRunTime = this.clock.instant().plus(Duration.ofMillis(unit.toMillis(initialDelay)));
        Intrinsics.checkNotNullExpressionValue((Object)nextRunTime, (String)"nextRunTime");
        Duration duration = Duration.ofMillis(unit.toMillis(delay));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(unit.toMillis(delay))");
        FixedDelayJob job = new FixedDelayJob(command, nextRunTime, duration);
        this.jobs.add(job);
        return new EmptyFuture((Function0<Unit>)((Function0)new Function0<Unit>(job){
            final /* synthetic */ FixedDelayJob $job;
            {
                this.$job = $job;
                super(0);
            }

            public final void invoke() {
                this.$job.setCancelled(true);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final int numPendingJobs() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.jobs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Job it = (Job)element$iv$iv;
            boolean bl = false;
            if (!(!it.getCancelled())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    public final void runOne() {
        boolean bl;
        Collection collection;
        while (true) {
            collection = this.jobs;
            bl = false;
            if (!(!collection.isEmpty()) || !((Job)this.jobs.get(0)).getCancelled()) break;
            this.jobs.remove(0);
        }
        collection = this.jobs;
        bl = false;
        if (!collection.isEmpty()) {
            Object e = this.jobs.remove(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"jobs.removeAt(0)");
            Job nextJob = (Job)e;
            if (this.clock.instant().compareTo(nextJob.getNextRunTime()) < 0) {
                this.clock.setTime(nextJob.getNextRunTime());
            }
            nextJob.run();
            if (nextJob instanceof RecurringJob) {
                ((RecurringJob)nextJob).updateNextRuntime(this.clock.instant());
                this.jobs.add(nextJob);
            }
        }
    }

    public final void runUntil(@NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        while (true) {
            Collection collection = this.jobs;
            boolean bl = false;
            if (!(!collection.isEmpty()) || this.clock.instant().compareTo(endTime) > 0 || ((Job)CollectionsKt.first((List)this.jobs)).getNextRunTime().compareTo(endTime) > 0) break;
            this.runOne();
        }
    }

    public final void run() {
        Instant now = this.clock.instant();
        Collection collection = this.jobs;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Object e = this.jobs.remove(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"jobs.removeAt(0)");
            Job job = (Job)e;
            if (!job.getCancelled()) {
                if (job.ready(now)) {
                    job.run();
                    if (job instanceof RecurringJob) {
                        ((RecurringJob)job).updateNextRuntime(now);
                        this.jobs.add(job);
                    }
                    this.run();
                } else {
                    this.jobs.add(0, job);
                }
            }
        }
    }
}

