/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.test.concurrent;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.test.concurrent.RecurringJob;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/test/concurrent/FixedRateJob;", "Lorg/jitsi/test/concurrent/RecurringJob;", "command", "Ljava/lang/Runnable;", "nextRunTime", "Ljava/time/Instant;", "period", "Ljava/time/Duration;", "(Ljava/lang/Runnable;Ljava/time/Instant;Ljava/time/Duration;)V", "getPeriod", "()Ljava/time/Duration;", "updateNextRuntime", "", "now", "jicoco-test-kotlin"})
public final class FixedRateJob
extends RecurringJob {
    @NotNull
    private final Duration period;

    public FixedRateJob(@NotNull Runnable command, @NotNull Instant nextRunTime, @NotNull Duration period) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)nextRunTime, (String)"nextRunTime");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        super(command, nextRunTime);
        this.period = period;
    }

    @NotNull
    public final Duration getPeriod() {
        return this.period;
    }

    @Override
    public void updateNextRuntime(@NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        FixedRateJob fixedRateJob = this;
        Instant instant = fixedRateJob.getNextRunTime().plus(this.period);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"nextRunTime += period");
        fixedRateJob.setNextRunTime(instant);
    }
}

