/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.health;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.Result;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012BO\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0004\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010.\u001a\u00020/H\u0016J\u0006\u00100\u001a\u00020/J\u0006\u00101\u001a\u00020/R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00048F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\u0017R\u0014\u0010\"\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0015\"\u0004\b+\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0015\"\u0004\b-\u0010\u0017\u00a8\u00063"}, d2={"Lorg/jitsi/health/HealthChecker;", "Lorg/jitsi/health/HealthCheckService;", "Lorg/jitsi/utils/concurrent/PeriodicRunnable;", "interval", "Ljava/time/Duration;", "timeout", "maxCheckDuration", "stickyFailures", "", "stickyFailuresGracePeriod", "healthCheckFunc", "Lkotlin/Function0;", "Lorg/jitsi/health/Result;", "clock", "Ljava/time/Clock;", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;ZLjava/time/Duration;Lkotlin/jvm/functions/Function0;Ljava/time/Clock;)V", "executor", "Lorg/jitsi/utils/concurrent/RecurringRunnableExecutor;", "hasFailed", "<set-?>", "getInterval", "()Ljava/time/Duration;", "setInterval", "(Ljava/time/Duration;)V", "interval$delegate", "Lkotlin/properties/ReadWriteProperty;", "lastResult", "lastResultTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getMaxCheckDuration", "setMaxCheckDuration", "result", "getResult", "()Lorg/jitsi/health/Result;", "serviceStartTime", "getStickyFailures", "()Z", "setStickyFailures", "(Z)V", "getStickyFailuresGracePeriod", "setStickyFailuresGracePeriod", "getTimeout", "setTimeout", "run", "", "start", "stop", "Companion", "jicoco"})
@SourceDebugExtension(value={"SMAP\nHealthChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HealthChecker.kt\norg/jitsi/health/HealthChecker\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,210:1\n33#2,3:211\n*S KotlinDebug\n*F\n+ 1 HealthChecker.kt\norg/jitsi/health/HealthChecker\n*L\n94#1:211,3\n*E\n"})
public final class HealthChecker
extends PeriodicRunnable
implements HealthCheckService {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private Duration timeout;
    @NotNull
    private Duration maxCheckDuration;
    private boolean stickyFailures;
    @NotNull
    private Duration stickyFailuresGracePeriod;
    @NotNull
    private final Function0<Result> healthCheckFunc;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @Nullable
    private RecurringRunnableExecutor executor;
    @NotNull
    private Result lastResult;
    private Instant lastResultTime;
    private Instant serviceStartTime;
    private boolean hasFailed;
    @NotNull
    private final ReadWriteProperty interval$delegate;
    @NotNull
    private static final Duration stickyFailuresGracePeriodDefault;

    public HealthChecker(@NotNull Duration interval, @NotNull Duration timeout, @NotNull Duration maxCheckDuration, boolean stickyFailures, @NotNull Duration stickyFailuresGracePeriod, @NotNull Function0<Result> healthCheckFunc, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)maxCheckDuration, (String)"maxCheckDuration");
        Intrinsics.checkNotNullParameter((Object)stickyFailuresGracePeriod, (String)"stickyFailuresGracePeriod");
        Intrinsics.checkNotNullParameter(healthCheckFunc, (String)"healthCheckFunc");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(interval.toMillis());
        this.timeout = timeout;
        this.maxCheckDuration = maxCheckDuration;
        this.stickyFailures = stickyFailures;
        this.stickyFailuresGracePeriod = stickyFailuresGracePeriod;
        this.healthCheckFunc = healthCheckFunc;
        this.clock = clock;
        this.logger = (Logger)new LoggerImpl(this.getClass().getName());
        this.lastResult = new Result(false, false, null, false, null, 31, null);
        this.lastResultTime = this.clock.instant();
        this.serviceStartTime = Instant.MAX;
        Delegates this_$iv = Delegates.INSTANCE;
        boolean $i$f$observable = false;
        this.interval$delegate = (ReadWriteProperty)new ObservableProperty<Duration>((Object)interval, this){
            final /* synthetic */ HealthChecker this$0;
            {
                this.this$0 = healthChecker;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void newValue2;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Duration duration = (Duration)newValue;
                Duration cfr_ignored_0 = (Duration)oldValue;
                boolean bl = false;
                this.this$0.setPeriod(newValue2.toMillis());
            }
        };
    }

    public /* synthetic */ HealthChecker(Duration duration, Duration duration2, Duration duration3, boolean bl, Duration duration4, Function0 function0, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            duration = DurationKt.getSecs((Number)10);
        }
        if ((n & 2) != 0) {
            duration2 = DurationKt.getSecs((Number)30);
        }
        if ((n & 4) != 0) {
            duration3 = DurationKt.getSecs((Number)3);
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            duration4 = stickyFailuresGracePeriodDefault;
        }
        if ((n & 0x40) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(duration, duration2, duration3, bl, duration4, (Function0<Result>)function0, clock);
    }

    @NotNull
    public final Duration getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.timeout = duration;
    }

    @NotNull
    public final Duration getMaxCheckDuration() {
        return this.maxCheckDuration;
    }

    public final void setMaxCheckDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.maxCheckDuration = duration;
    }

    public final boolean getStickyFailures() {
        return this.stickyFailures;
    }

    public final void setStickyFailures(boolean bl) {
        this.stickyFailures = bl;
    }

    @NotNull
    public final Duration getStickyFailuresGracePeriod() {
        return this.stickyFailuresGracePeriod;
    }

    public final void setStickyFailuresGracePeriod(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.stickyFailuresGracePeriod = duration;
    }

    @NotNull
    public final Duration getInterval() {
        return (Duration)this.interval$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setInterval(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.interval$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)duration);
    }

    @Override
    @NotNull
    public Result getResult() {
        Duration duration = Duration.between(this.lastResultTime, this.clock.instant());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        Duration timeSinceLastResult = duration;
        if (timeSinceLastResult.compareTo(this.timeout) > 0) {
            return new Result(false, true, null, false, "No health checks performed recently, the last result was " + timeSinceLastResult + " ago.", 12, null);
        }
        return this.lastResult;
    }

    public final void start() {
        if (this.executor == null) {
            this.executor = new RecurringRunnableExecutor(this.getClass().getName());
        }
        RecurringRunnableExecutor recurringRunnableExecutor = this.executor;
        Intrinsics.checkNotNull((Object)recurringRunnableExecutor);
        recurringRunnableExecutor.registerRecurringRunnable((RecurringRunnable)this);
        this.logger.info((Object)("Started with interval=" + this.getPeriod() + ", timeout=" + this.timeout + ", maxDuration=" + this.maxCheckDuration + ", stickyFailures=" + this.stickyFailures + "."));
    }

    public final void stop() throws Exception {
        RecurringRunnableExecutor recurringRunnableExecutor = this.executor;
        if (recurringRunnableExecutor != null) {
            RecurringRunnableExecutor recurringRunnableExecutor2;
            RecurringRunnableExecutor $this$stop_u24lambda_u241 = recurringRunnableExecutor2 = recurringRunnableExecutor;
            boolean bl = false;
            $this$stop_u24lambda_u241.deRegisterRecurringRunnable((RecurringRunnable)this);
            $this$stop_u24lambda_u241.close();
        }
        this.executor = null;
        this.logger.info((Object)"Stopped");
    }

    public void run() {
        Result result;
        super.run();
        Instant checkStart = this.clock.instant();
        try {
            result = (Result)this.healthCheckFunc.invoke();
        }
        catch (Exception e) {
            Instant now = this.clock.instant();
            Duration timeSinceStart = Duration.between(this.serviceStartTime, now);
            if (timeSinceStart.compareTo(this.stickyFailuresGracePeriod) > 0) {
                this.hasFailed = true;
            }
            result = new Result(false, true, null, false, "Failed to run health check: " + e.getMessage(), 12, null);
        }
        Result newResult = result;
        this.lastResultTime = this.clock.instant();
        Duration checkDuration = Duration.between(checkStart, this.lastResultTime);
        if (checkDuration.compareTo(this.maxCheckDuration) > 0) {
            newResult = new Result(false, false, null, false, "Performing a health check took too long: " + checkDuration, 14, null);
        }
        Result previousResult = this.lastResult;
        Result result2 = this.lastResult = this.stickyFailures && this.hasFailed && newResult.getSuccess() ? new Result(false, false, null, true, "Sticky failure.", 6, null) : newResult;
        if (newResult.getSuccess()) {
            String message = "Performed a successful health check in " + checkDuration + ". Sticky failure: " + (this.stickyFailures && this.hasFailed);
            if (previousResult.getSuccess()) {
                this.logger.debug((Object)message);
            } else {
                this.logger.info((Object)message);
            }
        } else {
            this.logger.error((Object)("Health check failed in " + checkDuration + ": " + newResult));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HealthChecker.class, "interval", "getInterval()Ljava/time/Duration;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        stickyFailuresGracePeriodDefault = duration;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/health/HealthChecker$Companion;", "", "()V", "stickyFailuresGracePeriodDefault", "Ljava/time/Duration;", "getStickyFailuresGracePeriodDefault", "()Ljava/time/Duration;", "jicoco"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getStickyFailuresGracePeriodDefault() {
            return stickyFailuresGracePeriodDefault;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

