/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rest;

import jakarta.servlet.DispatcherType;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rest.JettyBundleActivatorConfig;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\n\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u000b*\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\u0012*\u00020\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0013"}, d2={"servletContextHandler", "Lorg/eclipse/jetty/servlet/ServletContextHandler;", "Lorg/eclipse/jetty/server/Server;", "getServletContextHandler", "(Lorg/eclipse/jetty/server/Server;)Lorg/eclipse/jetty/servlet/ServletContextHandler;", "createJettyServer", "config", "Lorg/jitsi/rest/JettyBundleActivatorConfig;", "createSecureJettyServer", "createServer", "addServlet", "", "servlet", "Lorg/eclipse/jetty/servlet/ServletHolder;", "pathSpec", "", "enableCors", "isEnabled", "", "jicoco"})
@JvmName(name="JettyHelpers")
@SourceDebugExtension(value={"SMAP\nJettyHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyHelpers.kt\norg/jitsi/rest/JettyHelpers\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,134:1\n37#2,2:135\n37#2,2:137\n*S KotlinDebug\n*F\n+ 1 JettyHelpers.kt\norg/jitsi/rest/JettyHelpers\n*L\n69#1:135,2\n70#1:137,2\n*E\n"})
public final class JettyHelpers {
    @NotNull
    public static final Server createJettyServer(@NotNull JettyBundleActivatorConfig config) {
        HttpConfiguration httpConfiguration;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        HttpConfiguration $this$createJettyServer_u24lambda_u241 = httpConfiguration = new HttpConfiguration();
        boolean bl = false;
        $this$createJettyServer_u24lambda_u241.setSendServerVersion(config.getSendServerVersion());
        $this$createJettyServer_u24lambda_u241.addCustomizer(JettyHelpers::createJettyServer$lambda$1$lambda$0);
        HttpConfiguration httpConfig = httpConfiguration;
        HttpConfiguration $this$createJettyServer_u24lambda_u242 = $this$createJettyServer_u24lambda_u241 = new Server();
        boolean bl2 = false;
        $this$createJettyServer_u24lambda_u242.setHandler((Handler)new ServletContextHandler());
        HttpConfiguration server = $this$createJettyServer_u24lambda_u241;
        ServerConnector serverConnector = new ServerConnector[]{new HttpConnectionFactory(httpConfig)};
        ServerConnector $this$createJettyServer_u24lambda_u243 = serverConnector = new ServerConnector((Server)server, (ConnectionFactory[])serverConnector);
        boolean bl3 = false;
        $this$createJettyServer_u24lambda_u243.setPort(config.getPort());
        $this$createJettyServer_u24lambda_u243.setHost(config.getHost());
        ServerConnector connector = serverConnector;
        server.addConnector((Connector)connector);
        return server;
    }

    @NotNull
    public static final Server createSecureJettyServer(@NotNull JettyBundleActivatorConfig config) {
        SslContextFactory.Server server;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = config.getKeyStorePath();
        Intrinsics.checkNotNull((Object)string);
        File sslContextFactoryKeyStoreFile = Paths.get(string, new String[0]).toFile();
        SslContextFactory.Server $this$createSecureJettyServer_u24lambda_u244 = server = new SslContextFactory.Server();
        boolean bl = false;
        Collection $this$toTypedArray$iv = config.getTlsProtocols();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        $this$createSecureJettyServer_u24lambda_u244.setIncludeProtocols(Arrays.copyOf(stringArray, stringArray.length));
        $this$toTypedArray$iv = config.getTlsCipherSuites();
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        $this$createSecureJettyServer_u24lambda_u244.setIncludeCipherSuites(Arrays.copyOf(stringArray, stringArray.length));
        $this$createSecureJettyServer_u24lambda_u244.setRenegotiationAllowed(false);
        if (config.getKeyStorePassword() != null) {
            $this$createSecureJettyServer_u24lambda_u244.setKeyStorePassword(config.getKeyStorePassword());
        }
        $this$createSecureJettyServer_u24lambda_u244.setKeyStorePath(sslContextFactoryKeyStoreFile.getPath());
        $this$createSecureJettyServer_u24lambda_u244.setNeedClientAuth(config.getNeedClientAuth());
        SslContextFactory.Server sslContextFactory = server;
        SslContextFactory.Server $this$createSecureJettyServer_u24lambda_u245 = $this$createSecureJettyServer_u24lambda_u244 = new HttpConfiguration();
        boolean bl2 = false;
        $this$createSecureJettyServer_u24lambda_u245.setSecurePort(config.getTlsPort());
        $this$createSecureJettyServer_u24lambda_u245.setSecureScheme("https");
        $this$createSecureJettyServer_u24lambda_u245.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        $this$createSecureJettyServer_u24lambda_u245.setSendServerVersion(config.getSendServerVersion());
        SslContextFactory.Server httpConfig = $this$createSecureJettyServer_u24lambda_u244;
        SslContextFactory.Server $this$createSecureJettyServer_u24lambda_u246 = $this$createSecureJettyServer_u24lambda_u245 = new Server();
        boolean bl3 = false;
        $this$createSecureJettyServer_u24lambda_u246.setHandler((Handler)new ServletContextHandler());
        SslContextFactory.Server server2 = $this$createSecureJettyServer_u24lambda_u245;
        ServerConnector serverConnector = new ServerConnector[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory((HttpConfiguration)httpConfig)};
        ServerConnector $this$createSecureJettyServer_u24lambda_u247 = serverConnector = new ServerConnector((Server)server2, (ConnectionFactory[])serverConnector);
        boolean bl4 = false;
        $this$createSecureJettyServer_u24lambda_u247.setHost(config.getHost());
        $this$createSecureJettyServer_u24lambda_u247.setPort(config.getTlsPort());
        ServerConnector connector = serverConnector;
        server2.addConnector((Connector)connector);
        return server2;
    }

    @NotNull
    public static final Server createServer(@NotNull JettyBundleActivatorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config.isTls() ? JettyHelpers.createSecureJettyServer(config) : JettyHelpers.createJettyServer(config);
    }

    public static final boolean isEnabled(@NotNull JettyBundleActivatorConfig $this$isEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnabled, (String)"<this>");
        return $this$isEnabled.getPort() != -1 || $this$isEnabled.getTlsPort() != -1;
    }

    @NotNull
    public static final ServletContextHandler getServletContextHandler(@NotNull Server $this$servletContextHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$servletContextHandler, (String)"<this>");
        Handler handler = $this$servletContextHandler.getHandler();
        Intrinsics.checkNotNull((Object)handler, (String)"null cannot be cast to non-null type org.eclipse.jetty.servlet.ServletContextHandler");
        return (ServletContextHandler)handler;
    }

    public static final void enableCors(@NotNull ServletContextHandler $this$enableCors, @NotNull String pathSpec) {
        FilterHolder filterHolder;
        Intrinsics.checkNotNullParameter((Object)$this$enableCors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pathSpec, (String)"pathSpec");
        FilterHolder $this$enableCors_u24lambda_u248 = filterHolder = $this$enableCors.addFilter(CrossOriginFilter.class, pathSpec, EnumSet.of((Enum)DispatcherType.REQUEST));
        boolean bl = false;
        $this$enableCors_u24lambda_u248.setInitParameter("allowedOrigins", "*");
        $this$enableCors_u24lambda_u248.setInitParameter("Access-Control-Allow-Origin", "*");
        $this$enableCors_u24lambda_u248.setInitParameter("allowedMethods", "GET,POST");
        $this$enableCors_u24lambda_u248.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
    }

    public static /* synthetic */ void enableCors$default(ServletContextHandler servletContextHandler, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "/*";
        }
        JettyHelpers.enableCors(servletContextHandler, string);
    }

    public static final void addServlet(@NotNull Server $this$addServlet, @NotNull ServletHolder servlet, @NotNull String pathSpec) {
        Intrinsics.checkNotNullParameter((Object)$this$addServlet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)servlet, (String)"servlet");
        Intrinsics.checkNotNullParameter((Object)pathSpec, (String)"pathSpec");
        JettyHelpers.getServletContextHandler($this$addServlet).addServlet(servlet, pathSpec);
    }

    private static final void createJettyServer$lambda$1$lambda$0(Connector connector, HttpConfiguration httpConfiguration, Request request) {
        if (StringsKt.equals((String)request.getMethod(), (String)"TRACE", (boolean)true)) {
            request.setHandled(true);
            request.getResponse().setStatus(405);
        }
    }
}

