/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ProgressDialog.java
 *
 * Created on Apr 25, 2010, 12:45:39 PM
 */
package org.dts.spell.swing.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.WindowConstants;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.event.ProgressListener;

/**
 *
 * @author developer
 */
public class BlockProgressDialog extends javax.swing.JDialog implements ProgressListener {

  private ExecutorService loader = null;

  /** Creates new form ProgressDialog */
  public BlockProgressDialog(java.awt.Frame parent) {
    super(parent, true);
    initComponents();
    setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
  }

  @Override
  public void addNotify() {
    super.addNotify();
    if (null == loader) {
      loader = Executors.newSingleThreadExecutor();
    }
  }

  @Override
  public void removeNotify() {
    super.removeNotify();
    if (null != loader) {
      loader.shutdown();
      loader = null;
    }
  }

  public <T> T doTask(Callable<T> task) throws Exception {
    Future<T> result = loader.submit(task);
    setVisible(true);
    return result.get();
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    progressLabel = new javax.swing.JLabel();
    progressBar = new javax.swing.JProgressBar();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

    progressLabel.setText("jLabel1");

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(progressBar, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 554, Short.MAX_VALUE)
          .addComponent(progressLabel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 554, Short.MAX_VALUE))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addComponent(progressLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(18, 18, 18)
        .addComponent(progressBar, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  /**
   * @param args the command line arguments
   */
  public static void main(String args[]) {
    java.awt.EventQueue.invokeLater(new Runnable() {

      public void run() {
        BlockProgressDialog dialog = new BlockProgressDialog(new javax.swing.JFrame());
        dialog.addWindowListener(new java.awt.event.WindowAdapter() {

          public void windowClosing(java.awt.event.WindowEvent e) {
            System.exit(0);
          }
        });
        dialog.setVisible(true);
      }
    });
  }

  protected void doInEVT(Runnable run) {
    if (SwingUtilities.isEventDispatchThread()) {
      run.run();
    } else {
      SwingUtilities.invokeLater(run);
    }
  }

  protected void updateValues(ProgressEvent evt) {
    progressBar.setMinimum(0);
    progressBar.setMaximum(evt.getTotal());
    progressBar.setValue(evt.getStep());

    progressLabel.setText(evt.getProgress());
  }

  public void beginProgress(final ProgressEvent evt) {
    doInEVT(new Runnable() {

      public void run() {
        updateValues(evt);
      }
    });
  }

  public void nextStep(final ProgressEvent evt) {
    doInEVT(new Runnable() {

      public void run() {
        updateValues(evt);
      }
    });
  }

  public void endProgress(final ProgressEvent evt) {
    doInEVT(new Runnable() {

      public void run() {
        updateValues(evt);
        setVisible(false);
        dispose();
      }
    });
  }
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JProgressBar progressBar;
  private javax.swing.JLabel progressLabel;
  // End of variables declaration//GEN-END:variables
}
