/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.swing.utils.ErrorHighlighterPainter;
import org.dts.spell.swing.utils.TagList;

public class ErrorMarker {
    public static final String FULL_PROPERTY = "FULL_PROPERTY";
    public static final String FIRST_ERROR_PROPERTY = "FIRST_ERROR_PROPERTY";
    public static final String LAST_ERROR_PROPERTY = "LAST_ERROR_PROPERTY";
    public static final String CURRENT_ERROR_PROPERTY = "CURRENT_ERROR_PROPERTY";
    public static final String PREVIOUS_ERROR_PROPERTY = "PREVIOUS_ERROR_PROPERTY";
    public static final String NEXT_ERROR_PROPERTY = "NEXT_ERROR_PROPERTY";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JTextComponent textComponent = null;
    private Highlighter highlighter;
    private ErrorHighlighterPainter errorHighlighterPainter = new ErrorHighlighterPainter();
    private TagList errorList = new TagList(this.propertyChangeSupport);
    private TagSynchronizer caretListener = new TagSynchronizer();
    private boolean autoQuitSynchronizer = false;

    public static ErrorMarker get() {
        return new ErrorMarker();
    }

    public static ErrorMarker get(JTextComponent textComp) {
        return new ErrorMarker(textComp);
    }

    public static ErrorMarker get(JTextComponent textComp, boolean selectError) {
        return new ErrorMarker(textComp, selectError);
    }

    private ErrorMarker() {
        this(null, true);
    }

    private ErrorMarker(JTextComponent textComp) {
        this(textComp, true);
    }

    private ErrorMarker(JTextComponent textComp, boolean selectError) {
        this.setTextComponent(textComp);
        this.setSelectError(selectError);
    }

    public boolean isActive() {
        return null != this.textComponent && !this.isFull();
    }

    public void setErrorMarkColor(Color color) {
        this.errorHighlighterPainter.setErrorColor(color);
    }

    public Color getErrorMarkColor() {
        return this.errorHighlighterPainter.getErrorColor();
    }

    public boolean isSelectError() {
        return this.errorHighlighterPainter.isHighlightBackground();
    }

    public void setSelectError(boolean selectError) {
        this.errorHighlighterPainter.setHighlightBackground(selectError);
    }

    public void setTextComponent(JTextComponent textComp) {
        if (this.textComponent != textComp) {
            this.quitTextComponent();
            this.textComponent = textComp;
            if (null != this.textComponent) {
                this.textComponent.addCaretListener(this.caretListener);
                this.textComponent.getDocument().addDocumentListener(this.caretListener);
                this.errorList.updateCurrent(this.textComponent.getCaretPosition());
                this.highlighter = this.textComponent.getHighlighter();
            } else {
                this.highlighter = null;
            }
        }
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    void quitTextComponent(Document doc) {
        if (null != this.textComponent) {
            this.unMarkAllErrors();
            this.textComponent.removeCaretListener(this.caretListener);
            this.textComponent = null;
            this.highlighter = null;
        }
        doc.removeDocumentListener(this.caretListener);
    }

    public void quitTextComponent() {
        if (null != this.textComponent) {
            this.quitTextComponent(this.textComponent.getDocument());
        }
    }

    public boolean hasError(int position) {
        return this.errorList.hasTagAt(position);
    }

    public ErrorInfo getErrorInfo(int position) {
        return this.errorList.getErrorInfoAt(position);
    }

    public Object markError(int start, int end, ErrorInfo info, boolean scroll) throws BadLocationException {
        Object tag = this.highlighter.addHighlight(start, end, this.errorHighlighterPainter);
        this.errorList.add(tag, info);
        if (scroll) {
            this.textComponent.setCaretPosition(start);
        }
        return tag;
    }

    public Object markError(int start, int end, ErrorInfo info) throws BadLocationException {
        return this.markError(start, end, info, false);
    }

    public void unMarkError(Object tag) {
        this.highlighter.removeHighlight(tag);
        this.errorList.remove(tag);
    }

    public void unMarkRange(int begin, int end) {
        this.errorList.removeRange(begin, end, this.highlighter);
    }

    public void unMarkAllErrors() {
        this.errorList.removeAll(this.highlighter);
        this.errorList.clear();
    }

    public boolean isAutoQuit() {
        return this.autoQuitSynchronizer;
    }

    public void setAutoQuit(boolean auto) {
        this.autoQuitSynchronizer = auto;
    }

    public List<ErrorInfo> getAllErrorInfo() {
        return this.errorList.getAllErrorInfo();
    }

    public int getErrorCount() {
        return this.errorList.getNumOfErrors();
    }

    public boolean isFull() {
        return this.errorList.isFull();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(name, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propertyChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propertyChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public ErrorInfo getFirstError() {
        return this.errorList.getFirstError();
    }

    public ErrorInfo getLastError() {
        return this.errorList.getLastError();
    }

    public ErrorInfo getCurrentError() {
        return this.errorList.getCurrentError();
    }

    public ErrorInfo getPreviousError() {
        return this.errorList.getPreviousError();
    }

    public ErrorInfo getNextError() {
        return this.errorList.getNextError();
    }

    public String toString() {
        Highlighter.Highlight[] hl = this.highlighter.getHighlights();
        String result = "N\u00ba Highlight " + hl.length + "\n";
        for (int i = 0; i < hl.length; ++i) {
            if (hl[i].getPainter() == this.errorHighlighterPainter) {
                result = result + "*";
            }
            result = result + hl[i] + "\n";
        }
        return result;
    }

    private class TagSynchronizer
    implements CaretListener,
    DocumentListener {
        private TagSynchronizer() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            ErrorMarker.this.errorList.updateCurrent(e.getDot());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            int os = e.getOffset();
            ErrorMarker.this.errorList.removeNullRanges(os, os + e.getLength(), ErrorMarker.this.highlighter);
            if (ErrorMarker.this.errorList.isEmpty() && ErrorMarker.this.isAutoQuit()) {
                ErrorMarker.this.quitTextComponent();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

