/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.dts.spell.finder.Word;
import org.dts.spell.finder.WordFinder;
import org.dts.spell.swing.ErrorMarker;
import org.dts.spell.swing.ErrorToolTips;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.dts.spell.swing.utils.Messages;
import org.dts.spell.swing.utils.SeparatorLineBorder;

public class JSpellPanel
extends JPanel {
    private static final String WRONG_STRING = Messages.getString("JSpellPanel.WRONG_STRING");
    private static final String CHANGE_BY_STRING = Messages.getString("JSpellPanel.CHANGE_BY_STRING");
    private static final String IGNORE_ERROR_STRING = Messages.getString("JSpellPanel.IGNORE_ERROR_STRING");
    private static final String IGNORE_STRING = Messages.getString("JSpellPanel.IGNORE_STRING");
    private static final String IGNORE_ALL_STRING = Messages.getString("JSpellPanel.IGNORE_ALL_STRING");
    private static final String ADD_STRING = Messages.getString("JSpellPanel.ADD_STRING");
    private static final String REPLACE_STRING = Messages.getString("JSpellPanel.REPLACE_STRING");
    private static final String REPLACE_ALL_STRING = Messages.getString("JSpellPanel.REPLACE_ALL_STRING");
    private static final String CANCEL_STRING = Messages.getString("JSpellPanel.CANCEL_STRING");
    private static final String SUGGESTIONS_STRING = Messages.getString("JSpellPanel.SUGGESTIONS_STRING");
    private static final String NO_SUGGESTIONS_STRING = Messages.getString("JSpellPanel.NO_SUGGESTIONS_STRING");
    private static final String WHAT_DO_YOU_WANT_TO_DO_STRING = Messages.getString("JSpellPanel.WHAT_DO_YOU_WANT_TO_DO");
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final String CLOSE_CMD = "CLOSE_CMD";
    private MessageFormat wrongFormater;
    private JLabel wrongWordLabel;
    private JTextField checkText;
    private JList suggestList;
    private DefaultListModel suggestionListModel;
    private JButton replaceButton;
    private JButton ignoreButton;
    private SpellChecker spellChecker;
    private WordFinder wordFinder;
    private String wrongWord;
    private ErrorToolTips errorToolTips = new ErrorToolTips();
    protected final ListListener listListener = new ListListener();
    private ActionListener cancelListener;
    private ActionListener closeListener;

    protected SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    protected WordFinder getWordFinder() {
        return this.wordFinder;
    }

    protected boolean isStartSentence() {
        return this.wordFinder.current().isStartOfSentence();
    }

    protected SpellDictionary getDictionary() {
        return this.getSpellChecker().getDictionary();
    }

    protected boolean isEmpty(JList list) {
        return list.getFirstVisibleIndex() < 0 || list.getModel().getElementAt(0) == NO_SUGGESTIONS_STRING;
    }

    protected void clearSuggestionWords() {
        this.suggestionListModel.clear();
        this.suggestionListModel.addElement(NO_SUGGESTIONS_STRING);
    }

    protected void setSuggestionWords(List<String> list) {
        if (list.isEmpty()) {
            this.clearSuggestionWords();
        } else {
            this.suggestionListModel.clear();
            for (String word : list) {
                if (this.isStartSentence()) {
                    word = Word.getStartSentenceWordCase((CharSequence)word);
                }
                this.suggestionListModel.addElement(word);
            }
        }
    }

    public void init() {
        this.suggestionListModel = new DefaultListModel();
        this.createPanels();
        this.initFocus();
    }

    public void setCancelListener(ActionListener listener) {
        this.cancelListener = listener;
    }

    public void setCloseListener(ActionListener listener) {
        this.closeListener = listener;
    }

    protected void fireCancelAction() {
        if (null != this.cancelListener) {
            this.cancelListener.actionPerformed(new ActionEvent(this, 1001, CANCEL_CMD));
        }
    }

    protected void fireCloseAction() {
        if (null != this.closeListener) {
            this.closeListener.actionPerformed(new ActionEvent(this, 1001, CLOSE_CMD));
        }
    }

    protected JButton createButton(String id, final ActionListener action) {
        AbstractAction tempAction = new AbstractAction(id){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(e);
            }
        };
        return this.createButton(tempAction);
    }

    protected JButton createButton(Action action) {
        JButton result = new JButton(action);
        return result;
    }

    protected void setWrongWord(String txt) {
        this.wrongWordLabel.setText(this.getWrongWordMessageFormat().format(new Object[]{txt}));
        this.checkText.setText(txt);
        this.wrongWord = txt;
        this.setSuggestionWords(this.getDictionary().getSuggestions(txt));
        this.initFocus();
    }

    public void setWrongWord(WordFinder finder, SpellChecker checker) {
        this.spellChecker = checker;
        this.wordFinder = finder;
        this.setWrongWord(finder.current().getText());
    }

    protected MessageFormat createWrongWordMessageFormat() {
        return new MessageFormat(WRONG_STRING);
    }

    protected final MessageFormat getWrongWordMessageFormat() {
        return this.wrongFormater;
    }

    protected JLabel createWrongWordLabel() {
        JLabel result = new JLabel("");
        this.wrongFormater = this.createWrongWordMessageFormat();
        return result;
    }

    protected JPanel createNorthPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), WHAT_DO_YOU_WANT_TO_DO_STRING));
        this.wrongWordLabel = this.createWrongWordLabel();
        panel.add(this.wrongWordLabel);
        return panel;
    }

    protected JTextField createCheckTextField() {
        JTextField result = new JTextField();
        result.getDocument().addDocumentListener(new CheckTextListener(result));
        return result;
    }

    protected JLabel createSuggestionLabel() {
        return new JLabel(SUGGESTIONS_STRING);
    }

    protected JList createSuggestionList() {
        JList result = new JList();
        result.setSelectionMode(0);
        result.addListSelectionListener(this.listListener);
        result.addMouseListener(this.listListener);
        result.addFocusListener(this.listListener);
        result.setModel(this.suggestionListModel);
        this.clearSuggestionWords();
        return result;
    }

    protected JPanel createReplaceTextButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        this.replaceButton = this.createButton(REPLACE_STRING, EventHandler.create(ActionListener.class, this, "replaceCurrent"));
        panel.add(this.replaceButton);
        JButton replaceAllButton = this.createButton(REPLACE_ALL_STRING, EventHandler.create(ActionListener.class, this, "replaceAll"));
        panel.add(replaceAllButton);
        return panel;
    }

    protected JPanel createSuggestionPanel() {
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        JLabel label = this.createSuggestionLabel();
        this.suggestList = this.createSuggestionList();
        label.setLabelFor(this.suggestList);
        JScrollPane scrollPane = new JScrollPane(this.suggestList);
        panel.add((Component)label, "North");
        panel.add((Component)scrollPane, "Center");
        Rectangle cell = this.suggestList.getCellBounds(0, 0);
        scrollPane.setPreferredSize(new Dimension(cell.width, cell.height * 4));
        return panel;
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), CHANGE_BY_STRING));
        this.checkText = this.createCheckTextField();
        panel.add((Component)this.checkText, "North");
        panel.add((Component)this.createSuggestionPanel(), "Center");
        panel.add((Component)this.createReplaceTextButtonsPanel(), "South");
        return panel;
    }

    private JPanel createSouthPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setBorder(BorderFactory.createTitledBorder(SeparatorLineBorder.get(), IGNORE_ERROR_STRING));
        this.ignoreButton = this.createButton(IGNORE_STRING, EventHandler.create(ActionListener.class, this, "ignoreCurrent"));
        panel.add(this.ignoreButton);
        panel.add(this.createButton(IGNORE_ALL_STRING, EventHandler.create(ActionListener.class, this, "ignoreAll")));
        panel.add(this.createButton(ADD_STRING, EventHandler.create(ActionListener.class, this, "addCurrent")));
        panel.add(this.createButton(CANCEL_STRING, EventHandler.create(ActionListener.class, this, "cancel")));
        return panel;
    }

    protected void createPanels() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createNorthPanel(), "North");
        this.add((Component)this.createCenterPanel(), "Center");
        this.add((Component)this.createSouthPanel(), "South");
        this.clearSuggestionWords();
    }

    public String getNewWord() {
        return this.checkText.getText().trim();
    }

    public void ignoreCurrent() {
        this.fireCloseAction();
    }

    public void ignoreAll() {
        SpellChecker checker = this.getSpellChecker();
        checker.addIgnore(this.wrongWord);
        this.fireCloseAction();
    }

    public void addCurrent() {
        try {
            SpellDictionary dict = this.getDictionary();
            dict.addWord(this.wrongWord);
            this.fireCloseAction();
        }
        catch (SpellDictionaryException e) {
            ErrorMsgBox.show((Component)this, e);
            e.printStackTrace();
        }
    }

    public void replaceCurrent() {
        WordFinder finder = this.getWordFinder();
        finder.replace(this.getNewWord());
        this.fireCloseAction();
    }

    public void replaceAll() {
        SpellChecker checker = this.getSpellChecker();
        WordFinder finder = this.getWordFinder();
        finder.replace(this.getNewWord());
        checker.addReplace(this.wrongWord, this.getNewWord());
        this.fireCloseAction();
    }

    public void cancel() {
        this.fireCancelAction();
    }

    public void initFocus() {
        boolean empty = this.isEmpty(this.suggestList);
        this.suggestList.ensureIndexIsVisible(0);
        this.checkText.requestFocusInWindow();
        if (empty) {
            this.getRootPane().setDefaultButton(this.ignoreButton);
        } else {
            this.getRootPane().setDefaultButton(this.replaceButton);
        }
        this.suggestList.setFocusable(!empty);
    }

    protected class CheckTextListener
    implements DocumentListener {
        private ErrorMarker errorMarker;

        public CheckTextListener(JTextComponent textComponent) {
            this.errorMarker = ErrorMarker.get(textComponent, false);
            this.errorMarker.setAutoQuit(false);
            JSpellPanel.this.errorToolTips.addErrorMarker(this.errorMarker);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.checkWordSpell(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkWordSpell(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void checkWordSpell(Document doc) {
            try {
                int end = doc.getLength();
                boolean caseSensitive = JSpellPanel.this.spellChecker.isCaseSensitive();
                String text = doc.getText(0, end);
                this.errorMarker.unMarkAllErrors();
                JSpellPanel.this.spellChecker.setCaseSensitive(JSpellPanel.this.isStartSentence());
                ErrorInfo error = JSpellPanel.this.spellChecker.hasSpellErrors((CharSequence)text);
                if (error != null) {
                    this.errorMarker.markError(0, end, error);
                }
                JSpellPanel.this.spellChecker.setCaseSensitive(caseSensitive);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    protected class ListListener
    extends MouseAdapter
    implements ListSelectionListener,
    FocusListener {
        protected ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object selectedValue;
            JList list;
            if (!e.getValueIsAdjusting() && !JSpellPanel.this.isEmpty(list = (JList)e.getSource()) && (selectedValue = list.getSelectedValue()) != null) {
                JSpellPanel.this.checkText.setText(selectedValue.toString());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            if (e.getClickCount() == 2 && !JSpellPanel.this.isEmpty(JSpellPanel.this.suggestList) && (index = JSpellPanel.this.suggestList.locationToIndex(e.getPoint())) != -1) {
                JSpellPanel.this.replaceCurrent();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary() && JSpellPanel.this.suggestList.getSelectedIndex() < 0) {
                JSpellPanel.this.suggestList.setSelectedIndex(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

