/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.actions.ReplaceAllWordsAction;
import org.dts.spell.swing.actions.ReplaceWordAction;
import org.dts.spell.swing.utils.Messages;

public class JSuggestionList
extends JList {
    private static final String NO_SUGGESTIONS_STRING = Messages.getString("JSpellPanel.NO_SUGGESTIONS_STRING");
    private ReplaceWordAction replaceAction;
    private ReplaceAllWordsAction replaceAllAction;

    private static boolean isEmpty(JList list) {
        return list.getFirstVisibleIndex() < 0 || list.getModel().getElementAt(0) == NO_SUGGESTIONS_STRING;
    }

    public DefaultListModel getDefaultModel() {
        return (DefaultListModel)super.getModel();
    }

    public void setSuggestionWords(List<String> list, boolean startSentence, boolean selectFirst) {
        if (list.isEmpty()) {
            this.clearSuggestionWords();
        } else {
            this.getDefaultModel().clear();
            for (String word : list) {
                if (startSentence) {
                    word = Word.getStartSentenceWordCase((CharSequence)word);
                }
                this.getDefaultModel().addElement(word);
            }
            if (selectFirst) {
                this.setSelectedIndex(0);
            }
        }
    }

    public void clearSuggestionWords() {
        this.getDefaultModel().clear();
        this.getDefaultModel().addElement(NO_SUGGESTIONS_STRING);
        this.replaceAction.setSuggestion(null);
        this.replaceAllAction.setSuggestion(null);
    }

    public JSuggestionList(ReplaceWordAction replace, ReplaceAllWordsAction replaceAll) {
        this.replaceAction = replace;
        this.replaceAllAction = replaceAll;
        ListListener listListener = new ListListener();
        this.setModel(new DefaultListModel());
        this.setSelectionMode(0);
        this.addListSelectionListener(listListener);
        this.addMouseListener(listListener);
        this.addFocusListener(listListener);
        this.clearSuggestionWords();
    }

    protected class ListListener
    extends MouseAdapter
    implements ListSelectionListener,
    FocusListener {
        protected ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JList list = (JList)e.getSource();
                String suggestion = null;
                if (!JSuggestionList.isEmpty(list)) {
                    suggestion = (String)list.getSelectedValue();
                }
                JSuggestionList.this.replaceAction.setSuggestion(suggestion);
                JSuggestionList.this.replaceAllAction.setSuggestion(suggestion);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            JList list;
            if (e.getClickCount() == 2 && !JSuggestionList.isEmpty(list = (JList)e.getSource()) && (index = list.locationToIndex(e.getPoint())) != -1) {
                JSuggestionList.this.replaceAction.doAction(list);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            JList list;
            if (!e.isTemporary() && (list = (JList)e.getSource()).getSelectedIndex() < 0) {
                list.setSelectedIndex(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

