/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.dts.spell.ErrorInfo;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.dts.spell.event.SpellCheckListener;
import org.dts.spell.finder.Word;
import org.dts.spell.finder.WordFinder;
import org.dts.spell.swing.ErrorMarker;
import org.dts.spell.swing.ErrorPopUpMenu;
import org.dts.spell.swing.ErrorToolTips;
import org.dts.spell.swing.RealTimeSpellChecker;
import org.dts.spell.swing.actions.ActionManager;
import org.dts.spell.swing.actions.AddWordAction;
import org.dts.spell.swing.actions.DefaultActionManager;
import org.dts.spell.swing.actions.DeleteWordAction;
import org.dts.spell.swing.actions.IgnoreWordAction;
import org.dts.spell.swing.actions.RealTimeSpellCheckAction;
import org.dts.spell.swing.actions.ReplaceAllWordsAction;
import org.dts.spell.swing.actions.ReplaceWordAction;
import org.dts.spell.swing.actions.SpellCheckAction;
import org.dts.spell.swing.event.ErrorMarkerListener;
import org.dts.spell.swing.event.TextComponentSpellCheckerEvent;
import org.dts.spell.swing.event.TextComponentSpellCheckerListener;
import org.dts.spell.swing.event.UIErrorMarkerListener;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.utils.ErrorMsgBox;
import org.dts.spell.utils.EventMulticaster;

public class JTextComponentSpellChecker {
    private SpellChecker spellChecker;
    private UIErrorMarkerListener uiErrorListener = new UIErrorMarkerListener();
    private Map<JTextComponent, ErrorMarkerListener> errorMarkers = new HashMap<JTextComponent, ErrorMarkerListener>();
    private DocumentWordFinder defaultDocumentWordFinder = new DocumentWordFinder();
    private RealTimeSpellChecker realTimeSpellChecker = null;
    private ErrorToolTips errorToolTips = new ErrorToolTips();
    private ErrorPopUpMenu errorPopUpMenu = new ErrorPopUpMenu(this);
    private ActionManager actionManager = new DefaultActionManager();
    private EventMulticaster<TextComponentSpellCheckerListener> eventMulticaster = new EventMulticaster(TextComponentSpellCheckerListener.class);
    private static final String DESTROY_PROPERTY = "ancestor";
    private static final String DOCUMENT_PROPERTY = "document";
    private PropertyChangeListener automaticStopListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent cmp = (JTextComponent)evt.getSource();
            if (!cmp.isDisplayable()) {
                JTextComponentSpellChecker.this.stopRealtimeMarkErrors(cmp);
            }
        }
    };
    private PropertyChangeListener docChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTextComponent cmp = (JTextComponent)evt.getSource();
            Document oldDoc = (Document)evt.getOldValue();
            if (JTextComponentSpellChecker.this.isRealtimeMarkErrors(oldDoc, cmp)) {
                JTextComponentSpellChecker.this.startRealtimeMarkErrors(cmp, JTextComponentSpellChecker.this.stopRealtimeMarkErrors(oldDoc, cmp, false));
            }
        }
    };

    public JTextComponentSpellChecker(SpellChecker checker) {
        this.spellChecker = checker;
    }

    public void addListener(TextComponentSpellCheckerListener listener) {
        this.eventMulticaster.addListener((Object)listener);
    }

    public void removeListener(TextComponentSpellCheckerListener listener) {
        this.eventMulticaster.removeListener((Object)listener);
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    private ErrorMarkerListener getErrorMarkerListener(JTextComponent textComponent) {
        return this.errorMarkers.get(textComponent);
    }

    public void markErrors(JTextComponent textComponent) {
        this.markErrors(textComponent, this.defaultDocumentWordFinder);
    }

    public void markErrors(JTextComponent textComponent, DocumentWordFinder wordFinder) {
        ErrorMarkerListener listener = this.getErrorMarkerListener(textComponent);
        if (null == listener) {
            listener = new ErrorMarkerListener();
            this.errorMarkers.put(textComponent, listener);
        }
        Document doc = textComponent.getDocument();
        listener.setTextComponent(textComponent);
        wordFinder.setDocument(doc);
        this.spellChecker.check((WordFinder)wordFinder, (SpellCheckListener)listener);
        if (wordFinder == this.defaultDocumentWordFinder) {
            wordFinder.quitDocument();
        }
        this.markInManagers(listener.getErrorMarker());
    }

    public void unMarkErrors(JTextComponent textComponent) {
        ErrorMarkerListener listener = this.getErrorMarkerListener(textComponent);
        if (null == listener) {
            throw new IllegalArgumentException();
        }
        listener.setTextComponent(null);
        this.errorMarkers.remove(textComponent);
        this.unMarkInManagers(listener.getErrorMarker());
    }

    public boolean spellCheck(JTextComponent textComponent) {
        return this.spellCheck(textComponent, this.defaultDocumentWordFinder);
    }

    public boolean spellCheck(JTextComponent textComponent, DocumentWordFinder documentWordFinder) {
        Document doc = textComponent.getDocument();
        DocumentWordFinder wordFinder = null;
        boolean isRealTime = this.isRealtimeMarkErrors(textComponent);
        if (isRealTime) {
            wordFinder = this.realTimeSpellChecker.getWordFinder(textComponent);
            this.stopRealtimeMarkErrors(textComponent);
        }
        this.uiErrorListener.setTextComponent(textComponent);
        documentWordFinder.setDocument(doc);
        boolean result = this.spellChecker.check((WordFinder)documentWordFinder, (SpellCheckListener)this.uiErrorListener);
        this.uiErrorListener.quitTextComponent();
        if (!isRealTime) {
            documentWordFinder.quitDocument();
        } else {
            this.startRealtimeMarkErrors(textComponent, wordFinder);
        }
        return result;
    }

    public boolean isRealtimeMarkErrors(JTextComponent textComponent) {
        return null != this.realTimeSpellChecker && this.realTimeSpellChecker.isRealTimeSpellChecking(textComponent);
    }

    boolean isRealtimeMarkErrors(Document doc, JTextComponent textComponent) {
        return null != this.realTimeSpellChecker && this.realTimeSpellChecker.isRealTimeSpellChecking(doc, textComponent);
    }

    public ErrorMarker getErrorMarker(JTextComponent textComponent) {
        if (null != this.realTimeSpellChecker) {
            return this.realTimeSpellChecker.getErrorMarker(textComponent);
        }
        return null;
    }

    public void startRealtimeMarkErrors(JTextComponent textComponent) {
        this.startRealtimeMarkErrors(textComponent, new DocumentWordFinder());
    }

    public void startRealtimeMarkErrors(JTextComponent textComponent, DocumentWordFinder wordFinder) {
        Document doc = textComponent.getDocument();
        wordFinder.setDocument(doc);
        if (null == this.realTimeSpellChecker) {
            this.realTimeSpellChecker = new RealTimeSpellChecker(this.spellChecker);
            this.realTimeSpellChecker.start();
        }
        this.realTimeSpellChecker.addTextComponent(textComponent, wordFinder);
        this.markInManagers(this.realTimeSpellChecker.getErrorMarker(textComponent));
        textComponent.addPropertyChangeListener(DESTROY_PROPERTY, this.automaticStopListener);
        textComponent.addPropertyChangeListener(DOCUMENT_PROPERTY, this.docChangeListener);
        ((TextComponentSpellCheckerListener)this.eventMulticaster.getMulticaster()).realTimeStart(new TextComponentSpellCheckerEvent(this, textComponent));
    }

    public void stopRealtimeMarkErrors(JTextComponent textComponent) {
        this.stopRealtimeMarkErrors(textComponent.getDocument(), textComponent, true);
    }

    DocumentWordFinder stopRealtimeMarkErrors(Document doc, JTextComponent textComponent, boolean stopIfNoEditor) {
        DocumentWordFinder result = null;
        if (this.isRealtimeMarkErrors(doc, textComponent)) {
            TextComponentSpellCheckerEvent evt = new TextComponentSpellCheckerEvent(this, textComponent);
            ((TextComponentSpellCheckerListener)this.eventMulticaster.getMulticaster()).realTimeWillStop(evt);
            this.unMarkInManagers(this.realTimeSpellChecker.getErrorMarker(doc, textComponent));
            result = this.realTimeSpellChecker.removeTextComponent(doc, textComponent);
            textComponent.removePropertyChangeListener(DESTROY_PROPERTY, this.automaticStopListener);
            textComponent.removePropertyChangeListener(DOCUMENT_PROPERTY, this.docChangeListener);
            ((TextComponentSpellCheckerListener)this.eventMulticaster.getMulticaster()).realTimeStop(evt);
            if (stopIfNoEditor && this.realTimeSpellChecker.isEmpty()) {
                this.realTimeSpellChecker.stop();
                this.realTimeSpellChecker = null;
            }
        }
        return result;
    }

    public void stopRealtimeMarkErrors() {
        if (null != this.realTimeSpellChecker) {
            for (ErrorMarker errorMarker : this.realTimeSpellChecker.getErrorMarkers()) {
                JTextComponent textComponent = errorMarker.getTextComponent();
                TextComponentSpellCheckerEvent evt = new TextComponentSpellCheckerEvent(this, textComponent);
                ((TextComponentSpellCheckerListener)this.eventMulticaster.getMulticaster()).realTimeWillStop(evt);
                this.unMarkInManagers(errorMarker);
                this.realTimeSpellChecker.removeTextComponent(textComponent);
                ((TextComponentSpellCheckerListener)this.eventMulticaster.getMulticaster()).realTimeStop(evt);
            }
            this.realTimeSpellChecker.stop();
            this.realTimeSpellChecker = null;
        }
    }

    protected void markInManagers(ErrorMarker errorMarker) {
        if (null != this.errorToolTips) {
            this.errorToolTips.addErrorMarker(errorMarker);
        }
        if (null != this.errorPopUpMenu) {
            this.errorPopUpMenu.addErrorMarker(errorMarker);
        }
    }

    protected void unMarkInManagers(ErrorMarker errorMarker) {
        if (null != this.errorToolTips) {
            this.errorToolTips.removeErrorMarker(errorMarker);
        }
        if (null != this.errorPopUpMenu) {
            this.errorPopUpMenu.removeErrorMarker(errorMarker);
        }
    }

    public ErrorToolTips getErrorToolTips() {
        return this.errorToolTips;
    }

    public void setErrorToolTips(ErrorToolTips errorToolTips) {
        this.errorToolTips = errorToolTips;
    }

    public ErrorPopUpMenu getErrorPopUpMenu() {
        return this.errorPopUpMenu;
    }

    public void setErrorPopUpMenu(ErrorPopUpMenu errorPopUpMenu) {
        this.errorPopUpMenu = errorPopUpMenu;
    }

    public ActionManager getActionManager() {
        return this.actionManager;
    }

    public void setActionManager(ActionManager actionManager) {
        this.actionManager = actionManager;
    }

    public void recheckAll(JTextComponent textComponent) {
        if (this.isRealtimeMarkErrors(textComponent)) {
            this.realTimeSpellChecker.addTextRange(textComponent.getDocument());
        }
    }

    public void recheckErrors(JTextComponent textComponent) {
        ErrorMarker errorMarker;
        if (null != this.realTimeSpellChecker && null != (errorMarker = this.realTimeSpellChecker.getErrorMarker(textComponent))) {
            Document doc = errorMarker.getTextComponent().getDocument();
            for (ErrorInfo error : errorMarker.getAllErrorInfo()) {
                Word badWord = error.getBadWord();
                this.realTimeSpellChecker.addTextRange(doc, badWord.getStart(), badWord.length());
            }
        }
    }

    public void addWordToDictionary(JTextComponent textComponent, String badWord, SpellDictionary dictionary) {
        try {
            dictionary.addWord(badWord);
            this.recheckErrors(textComponent);
        }
        catch (SpellDictionaryException ex) {
            ErrorMsgBox.show(ex);
        }
    }

    public void ignoreWord(JTextComponent textComponent, String badWord) {
        this.spellChecker.addIgnore(badWord);
        this.recheckErrors(textComponent);
    }

    public void replaceAllBadWords(JTextComponent textComponent, String badWord, String newWord) {
        this.spellChecker.addReplace(badWord, newWord);
        this.recheckErrors(textComponent);
    }

    public void replaceBadWord(JTextComponent textComponent, Word badWord, String suggestion) {
        int end = badWord.getEnd();
        int start = badWord.getStart();
        if (suggestion.isEmpty()) {
            --start;
        }
        textComponent.select(start, end);
        textComponent.replaceSelection(suggestion);
    }

    public void deleteBadWord(JTextComponent textComponent, Word badWord) {
        int end = badWord.getEnd();
        int start = badWord.getStart() - 1;
        textComponent.select(start, end);
        textComponent.replaceSelection("");
    }

    public AddWordAction getAddWordAction() {
        return this.actionManager.getAddWordAction(this);
    }

    public IgnoreWordAction getIgnoreWordAction() {
        return this.actionManager.getIgnoreWordAction(this);
    }

    public DeleteWordAction getDeleteWordAction() {
        return this.actionManager.getDeleteWordAction(this);
    }

    public SpellCheckAction getSpellCheckAction() {
        return this.actionManager.getSpellCheckAction(this);
    }

    public RealTimeSpellCheckAction getRealTimeSpellCheckAction() {
        return this.actionManager.getRealTimeSpellCheckAction(this);
    }

    public ReplaceWordAction getReplaceWordAction() {
        return this.actionManager.getReplaceWordAction(this);
    }

    public ReplaceAllWordsAction getReplaceAllWordsAction() {
        return this.actionManager.getReplaceAllWordsAction(this);
    }

    public ReplaceWordAction getReplaceWordAction(String sugestion) {
        return this.actionManager.getReplaceWordAction(this, sugestion);
    }
}

