/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.actions;

import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.actions.AbstractSpellCheckerAction;
import org.dts.spell.swing.actions.SpellCheckAction;
import org.dts.spell.swing.utils.Messages;

public class RealTimeSpellCheckAction
extends AbstractSpellCheckerAction {
    private JTextComponentSpellChecker textCmpSpellChecker;

    protected RealTimeSpellCheckAction(JTextComponentSpellChecker textCmpSpellChecker) {
        super(Messages.getString("ACTION_REALTIME_SPELL_CHECK"));
        this.textCmpSpellChecker = textCmpSpellChecker;
        this.putValue("SmallIcon", new ImageIcon(SpellCheckAction.class.getResource("images/stock_autospellcheck.png")));
    }

    protected JTextComponentSpellChecker getTextComponentSpellChecker() {
        return this.textCmpSpellChecker;
    }

    protected void onStartRealtimeMarkErrors(JTextComponent txtCmp) {
        this.textCmpSpellChecker.startRealtimeMarkErrors(txtCmp);
    }

    protected void onStopRealtimeMarkErrors(JTextComponent txtCmp) {
        this.textCmpSpellChecker.stopRealtimeMarkErrors(txtCmp);
    }

    @Override
    public void onFocusedTextComponentChanged(JTextComponent textCmp) {
        super.onFocusedTextComponentChanged(textCmp);
        if (null != textCmp) {
            this.putValue("SwingSelectedKey", this.textCmpSpellChecker.isRealtimeMarkErrors(textCmp));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent txtCmp = this.getTextComponent(e);
        if (null != txtCmp) {
            if (this.textCmpSpellChecker.isRealtimeMarkErrors(txtCmp)) {
                this.onStopRealtimeMarkErrors(txtCmp);
            } else {
                this.onStartRealtimeMarkErrors(txtCmp);
            }
            this.putValue("SwingSelectedKey", this.textCmpSpellChecker.isRealtimeMarkErrors(txtCmp));
            txtCmp.requestFocusInWindow();
        }
    }
}

