/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.Dimension;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.dts.spell.ErrorInfo;
import org.dts.spell.swing.actions.ErrorInfoAction;
import org.dts.spell.swing.panels.SolutionPanel;

public abstract class SimpleSolutionPanel
extends SolutionPanel {
    private String title;
    private String description;
    private JButton applyButton;
    private JLabel label;

    public SimpleSolutionPanel(String name) {
        this((Action)null, name);
    }

    public SimpleSolutionPanel(ErrorInfoAction action, String name) {
        this((Action)action, name);
    }

    public SimpleSolutionPanel(Action action, String name) {
        this(action, name, "", "");
    }

    public SimpleSolutionPanel(Action action, String name, String title, String description) {
        super(name);
        this.title = title;
        this.description = description;
        this.initFromAction(action);
    }

    protected void initFromAction(Action action) {
        this.label = this.createNoWidthLabel(this.getDescription());
        this.applyButton = new JButton(action);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.label);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.applyButton);
    }

    protected void setAction(Action action) {
        this.applyButton.setAction(action);
    }

    protected Action getAction() {
        return this.applyButton.getAction();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void activePanel(ErrorInfo errorInfo) {
        Action action = this.getAction();
        if (action instanceof ErrorInfoAction) {
            ((ErrorInfoAction)action).setErrorInfo(errorInfo);
        }
        this.label.setText(this.getDescription());
    }

    protected void setTitle(String title) {
        this.title = title;
    }

    protected String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }
}

