/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.dts.spell.ErrorInfo;
import org.dts.spell.swing.JTextComponentSpellChecker;

public abstract class SolutionPanel
extends JPanel {
    private ErrorInfo errorInfo;

    public SolutionPanel(String name) {
        this.setName(name);
    }

    public SolutionPanel(boolean isDoubleBuffered, String name) {
        super(isDoubleBuffered);
        this.setName(name);
    }

    public SolutionPanel(LayoutManager layout, boolean isDoubleBuffered, String name) {
        super(layout, isDoubleBuffered);
        this.setName(name);
    }

    public SolutionPanel(LayoutManager layout, String name) {
        super(layout);
        this.setName(name);
    }

    public abstract String getTitle();

    public abstract void calcSolution(ErrorInfo var1);

    public abstract void activePanel(ErrorInfo var1);

    public abstract boolean isForError(ErrorInfo var1);

    public void initFrom(JTextComponentSpellChecker txtCmpSpellChecker) {
    }

    protected JLabel createNoWidthLabel(String txt) {
        if (txt.isEmpty()) {
            txt = "X";
        }
        JLabel label = new JLabel(txt);
        label.setPreferredSize(new Dimension(0, label.getPreferredSize().height));
        return label;
    }

    protected void recalcSize(JLabel label, String txt) {
        label.setPreferredSize(null);
        label.setText(txt);
        label.setPreferredSize(new Dimension(0, label.getPreferredSize().height));
        label.invalidate();
        this.doLayout();
    }

    boolean tryActivatePanel(ErrorInfo errorInfo) {
        boolean result;
        boolean bl = result = errorInfo == this.errorInfo;
        if (result) {
            this.activePanel(errorInfo);
        }
        return result;
    }

    void doCalcSolution(ErrorInfo errorInfo) {
        this.errorInfo = errorInfo;
        this.calcSolution(errorInfo);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(enabled);
        }
    }
}

