/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.dts.spell.ErrorInfo;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.JSuggestionList;
import org.dts.spell.swing.JTextComponentSpellChecker;
import org.dts.spell.swing.panels.SolutionPanel;
import org.dts.spell.swing.utils.Messages;

public class SpellErrorSolutionPanel
extends SolutionPanel {
    private String title;
    private JSuggestionList sugestionList;
    private List<String> suggestions;
    private JTextComponentSpellChecker txtCmpSpellChecker;

    public SpellErrorSolutionPanel() {
        super("SPELLING_ERROR_PANEL");
    }

    protected JSuggestionList createSuggestionList() {
        return new JSuggestionList(this.txtCmpSpellChecker.getReplaceWordAction(), this.txtCmpSpellChecker.getReplaceAllWordsAction());
    }

    protected JPanel createButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(4, 1));
        panel.add(new JButton(this.txtCmpSpellChecker.getReplaceWordAction()));
        panel.add(new JButton(this.txtCmpSpellChecker.getReplaceAllWordsAction()));
        panel.add(new JButton(this.txtCmpSpellChecker.getIgnoreWordAction()));
        panel.add(new JButton(this.txtCmpSpellChecker.getAddWordAction()));
        return panel;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void calcSolution(ErrorInfo errorInfo) {
        Word badWord = errorInfo.getBadWord();
        this.title = Messages.getString("JRealTimeSpellPanel.SPELL_ERROR_TITLE", badWord);
        this.suggestions = errorInfo.getDictionary().getSuggestions(badWord.getText());
    }

    @Override
    public void activePanel(ErrorInfo errorInfo) {
        this.txtCmpSpellChecker.getAddWordAction().setErrorInfo(errorInfo);
        this.txtCmpSpellChecker.getIgnoreWordAction().setErrorInfo(errorInfo);
        this.txtCmpSpellChecker.getReplaceWordAction().setErrorInfo(errorInfo);
        this.txtCmpSpellChecker.getReplaceAllWordsAction().setErrorInfo(errorInfo);
        this.sugestionList.setSuggestionWords(this.suggestions, errorInfo.getBadWord().isStartOfSentence(), true);
    }

    @Override
    public boolean isForError(ErrorInfo errorInfo) {
        if (null != errorInfo) {
            return errorInfo.isSpellingError();
        }
        return false;
    }

    @Override
    public void initFrom(JTextComponentSpellChecker txtCmpSpellChecker) {
        super.initFrom(txtCmpSpellChecker);
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel("Algunas sugerencias son :");
        this.add((Component)label, "North");
        this.txtCmpSpellChecker = txtCmpSpellChecker;
        this.sugestionList = this.createSuggestionList();
        this.add((Component)new JScrollPane(this.sugestionList), "Center");
        JPanel buttonsPanel = this.createButtonsPanel();
        this.add((Component)buttonsPanel, "South");
    }
}

