/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.dts.spell.event.ProgressEvent;
import org.dts.spell.event.ProgressListener;

public class BlockProgressDialog
extends JDialog
implements ProgressListener {
    private ExecutorService loader = null;
    private JProgressBar progressBar;
    private JLabel progressLabel;

    public BlockProgressDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setDefaultCloseOperation(0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (null == this.loader) {
            this.loader = Executors.newSingleThreadExecutor();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (null != this.loader) {
            this.loader.shutdown();
            this.loader = null;
        }
    }

    public <T> T doTask(Callable<T> task) throws Exception {
        Future<T> result = this.loader.submit(task);
        this.setVisible(true);
        return result.get();
    }

    private void initComponents() {
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.setDefaultCloseOperation(2);
        this.progressLabel.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.progressBar, GroupLayout.Alignment.LEADING, -1, 554, Short.MAX_VALUE).addComponent(this.progressLabel, GroupLayout.Alignment.LEADING, -1, 554, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.progressLabel, -2, 46, -2).addGap(18, 18, 18).addComponent(this.progressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BlockProgressDialog dialog = new BlockProgressDialog(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    protected void doInEVT(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    protected void updateValues(ProgressEvent evt) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(evt.getTotal());
        this.progressBar.setValue(evt.getStep());
        this.progressLabel.setText(evt.getProgress());
    }

    public void beginProgress(final ProgressEvent evt) {
        this.doInEVT(new Runnable(){

            @Override
            public void run() {
                BlockProgressDialog.this.updateValues(evt);
            }
        });
    }

    public void nextStep(final ProgressEvent evt) {
        this.doInEVT(new Runnable(){

            @Override
            public void run() {
                BlockProgressDialog.this.updateValues(evt);
            }
        });
    }

    public void endProgress(final ProgressEvent evt) {
        this.doInEVT(new Runnable(){

            @Override
            public void run() {
                BlockProgressDialog.this.updateValues(evt);
                BlockProgressDialog.this.setVisible(false);
                BlockProgressDialog.this.dispose();
            }
        });
    }
}

