/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class TextRange {
    private Position begin;
    private Position end;
    private boolean remove;
    private Document document;

    public TextRange(DocumentEvent e) throws BadLocationException {
        this.document = e.getDocument();
        this.begin = this.document.createPosition(e.getOffset());
        this.remove = DocumentEvent.EventType.REMOVE == e.getType();
        this.end = !this.remove ? this.document.createPosition(e.getOffset() + e.getLength()) : this.begin;
    }

    public TextRange(Document doc) {
        this(doc, doc.getStartPosition(), doc.getEndPosition());
    }

    public TextRange(Document document, Position begin, Position end) {
        this.document = document;
        this.begin = begin;
        this.end = end;
        this.remove = false;
    }

    public int compare(int index) {
        if (this.begin.getOffset() > index) {
            return -1;
        }
        if (this.end.getOffset() < index) {
            return 1;
        }
        return 0;
    }

    public TextRange compactWith(DocumentEvent e) throws BadLocationException {
        TextRange result;
        int newBegin = e.getOffset();
        int newEnd = e.getOffset() + e.getLength();
        if (e.getDocument() != this.document) {
            result = new TextRange(e);
        } else if (DocumentEvent.EventType.REMOVE == e.getType()) {
            result = this.isInside(newBegin) || this.isInside(newEnd) ? null : new TextRange(e);
        } else {
            int currentBegin = this.getBegin();
            int currentEnd = this.getEnd();
            if (newEnd < currentBegin || newBegin > currentEnd) {
                result = new TextRange(e);
            } else {
                Document doc = e.getDocument();
                if (newBegin < currentBegin) {
                    this.begin = doc.createPosition(newBegin);
                }
                if (newEnd > currentEnd) {
                    this.end = doc.createPosition(newEnd);
                }
                this.remove = false;
                result = null;
            }
        }
        return result;
    }

    public boolean isInside(int index) {
        return this.compare(index) == 0;
    }

    public int getBegin() {
        return this.begin.getOffset();
    }

    public int getEnd() {
        return this.end.getOffset();
    }

    public boolean isEmpty() {
        return this.getBegin() == this.getEnd();
    }

    public boolean isRemove() {
        return this.remove;
    }

    public Document getDocument() {
        return this.document;
    }

    public String toString() {
        return "text_range = " + this.getBegin() + ", " + this.getEnd();
    }
}

