/*
 * Copyright @ 2015 Atlassian Pty Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

/**
 *
 * @author Jing Dai
 * @author Dingxin Xu
 */
public class BwexpanderFLP
{
    /**
     * Chirp (bw expand) LP AR filter.
     * @param ar AR filter to be expanded (without leading 1).
     * @param ar_offset offset of valid data.
     * @param d length of ar.
     * @param chirp chirp factor (typically in range (0..1) ).
     */
    static void SKP_Silk_bwexpander_FLP(
        float[]           ar,        /* I/O  AR filter to be expanded (without leading 1)    */
        int ar_offset,
        final int       d,          /* I    length of ar                                    */
        final float     chirp       /* I    chirp factor (typically in range (0..1) )       */
    )
    {
        int   i;
        float cfac = chirp;

        for( i = 0; i < d - 1; i++ )
        {
            ar[ ar_offset+i ] *=  cfac;
            cfac    *=  chirp;
        }
        ar[ ar_offset + d - 1 ] *=  cfac;
    }
}
