/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Clock;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.media.rtp.OutputDataStream;
import net.sf.fmj.media.util.MediaThread;
import org.jitsi.impl.neomedia.RTPConnectorInputStream;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.utils.ConfigUtils;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.queue.QueueStatistics;
import org.jitsi.utils.stats.RateStatistics;

public abstract class RTPConnectorOutputStream
implements OutputDataStream {
    private static final Logger logger = Logger.getLogger(RTPConnectorOutputStream.class);
    public static final int PACKET_QUEUE_CAPACITY;
    public static final int POOL_CAPACITY;
    private static final int AVERAGE_BITRATE_WINDOW_MS;
    private static final boolean USE_SEND_THREAD;
    private static final String USE_SEND_THREAD_PNAME;
    private static final String PACKET_QUEUE_CAPACITY_PNAME;
    private static final String POOL_CAPACITY_PNAME;
    private static final String AVERAGE_BITRATE_WINDOW_MS_PNAME;
    private boolean enabled = true;
    private long numberOfBytesSent = 0L;
    private long numberOfPackets = 0L;
    private int numDroppedPackets = 0;
    private PacketLoggingService pktLogging;
    private final LinkedBlockingQueue<RawPacket> rawPacketPool = new LinkedBlockingQueue(POOL_CAPACITY);
    protected final List<InetSocketAddress> targets = new LinkedList<InetSocketAddress>();
    private final Queue queue;
    private boolean closed = false;
    private final RateStatistics rateStatistics = new RateStatistics(AVERAGE_BITRATE_WINDOW_MS);

    public static boolean logDroppedPacket(int numDroppedPackets) {
        return numDroppedPackets == 1 || numDroppedPackets <= 1000 && numDroppedPackets % 100 == 0 || numDroppedPackets % 1000 == 0;
    }

    static boolean logPacket(long numOfPacket) {
        return numOfPacket == 1L || numOfPacket == 300L || numOfPacket == 500L || numOfPacket == 1000L || numOfPacket % 5000L == 0L;
    }

    protected RTPConnectorOutputStream() {
        this.queue = USE_SEND_THREAD ? new Queue() : null;
    }

    public void addTarget(InetAddress remoteAddr, int remotePort) {
        InetSocketAddress target = new InetSocketAddress(remoteAddr, remotePort);
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.removeTargets();
        }
    }

    protected RawPacket[] packetize(byte[] buf, int off, int len, Object context) {
        byte[] pktBuffer;
        RawPacket[] pkts = new RawPacket[1];
        RawPacket pkt = this.rawPacketPool.poll();
        if (pkt == null) {
            pktBuffer = new byte[len];
            pkt = new RawPacket();
        } else {
            pktBuffer = pkt.getBuffer();
        }
        if (pktBuffer.length < len) {
            pktBuffer = new byte[len];
        }
        pkt.setBuffer(pktBuffer);
        pkt.setFlags(0);
        pkt.setLength(len);
        pkt.setOffset(0);
        System.arraycopy(buf, off, pktBuffer, 0, len);
        pkts[0] = pkt;
        return pkts;
    }

    protected abstract void doLogPacket(RawPacket var1, InetSocketAddress var2);

    public long getNumberOfBytesSent() {
        return this.numberOfBytesSent;
    }

    protected PacketLoggingService getPacketLoggingService() {
        if (this.pktLogging == null) {
            this.pktLogging = LibJitsi.getPacketLoggingService();
        }
        return this.pktLogging;
    }

    protected abstract boolean isSocketValid();

    public boolean removeTarget(InetAddress remoteAddr, int remotePort) {
        Iterator<InetSocketAddress> targetIter = this.targets.iterator();
        while (targetIter.hasNext()) {
            InetSocketAddress target = targetIter.next();
            if (!target.getAddress().equals(remoteAddr) || target.getPort() != remotePort) continue;
            targetIter.remove();
            return true;
        }
        return false;
    }

    public void removeTargets() {
        this.targets.clear();
    }

    private boolean send(RawPacket packet) {
        if (!this.isSocketValid()) {
            this.rawPacketPool.offer(packet);
            return false;
        }
        ++this.numberOfPackets;
        if (this.targets.isEmpty()) {
            logger.warn((Object)"targets list empty, not sending packet");
        }
        for (InetSocketAddress target : this.targets) {
            try {
                PacketLoggingService pktLogging;
                this.sendToTarget(packet, target);
                this.numberOfBytesSent += (long)packet.getLength();
                if (!RTPConnectorOutputStream.logPacket(this.numberOfPackets) || (pktLogging = this.getPacketLoggingService()) == null || !pktLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) continue;
                this.doLogPacket(packet, target);
            }
            catch (IOException ioe) {
                this.rawPacketPool.offer(packet);
                logger.error((Object)("Failed to send a packet to target " + target + ":" + ioe));
                return false;
            }
        }
        this.rawPacketPool.offer(packet);
        return true;
    }

    protected abstract void sendToTarget(RawPacket var1, InetSocketAddress var2) throws IOException;

    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setEnabled: " + enabled));
            }
            this.enabled = enabled;
        }
    }

    public boolean setMaxPacketsPerMillis(int maxPackets, long perMillis) {
        if (this.queue != null) {
            this.queue.setMaxPacketsPerMillis(maxPackets, perMillis);
        } else {
            logger.error((Object)"Cannot enable pacing: send thread disabled.");
        }
        return this.queue != null;
    }

    public void setPriority(int priority) {
    }

    public int write(byte[] buf, int off, int len) {
        return this.write(buf, off, len, null);
    }

    public int syncWrite(byte[] buf, int off, int len) {
        return this.syncWrite(buf, off, len, null);
    }

    private int syncWrite(byte[] buf, int off, int len, Object context) {
        int result = -1;
        RawPacket[] pkts = this.packetize(buf, off, len, context);
        if (pkts != null) {
            if (this.write(pkts)) {
                result = len;
            }
        } else {
            result = len;
        }
        return result;
    }

    protected int write(byte[] buf, int off, int len, Object context) {
        if (this.enabled) {
            if (logger.isDebugEnabled() && this.targets.isEmpty()) {
                logger.debug((Object)"Write called without targets!", new Throwable());
            }
            if (this.queue != null) {
                this.queue.write(buf, off, len, context);
            } else {
                this.syncWrite(buf, off, len, context);
            }
        }
        return len;
    }

    private boolean write(RawPacket[] pkts) {
        if (this.closed) {
            return false;
        }
        if (pkts == null) {
            return true;
        }
        boolean success = true;
        long now = System.currentTimeMillis();
        for (RawPacket pkt : pkts) {
            if (pkt == null) continue;
            if (success) {
                if (!this.send(pkt)) {
                    success = false;
                    continue;
                }
                this.rateStatistics.update(pkt.getLength(), now);
                continue;
            }
            this.rawPacketPool.offer(pkt);
        }
        return success;
    }

    public long getOutputBitrate() {
        return this.getOutputBitrate(System.currentTimeMillis());
    }

    public long getOutputBitrate(long now) {
        return this.rateStatistics.getRate(now);
    }

    static {
        USE_SEND_THREAD_PNAME = RTPConnectorOutputStream.class.getName() + ".USE_SEND_THREAD";
        PACKET_QUEUE_CAPACITY_PNAME = RTPConnectorOutputStream.class.getName() + ".PACKET_QUEUE_CAPACITY";
        POOL_CAPACITY_PNAME = RTPConnectorOutputStream.class.getName() + ".POOL_CAPACITY";
        AVERAGE_BITRATE_WINDOW_MS_PNAME = RTPConnectorOutputStream.class.getName() + ".AVERAGE_BITRATE_WINDOW_MS";
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        USE_SEND_THREAD = ConfigUtils.getBoolean((ConfigurationService)cfg, (String)USE_SEND_THREAD_PNAME, (boolean)true);
        POOL_CAPACITY = ConfigUtils.getInt((ConfigurationService)cfg, (String)POOL_CAPACITY_PNAME, (int)100);
        AVERAGE_BITRATE_WINDOW_MS = ConfigUtils.getInt((ConfigurationService)cfg, (String)AVERAGE_BITRATE_WINDOW_MS_PNAME, (int)5000);
        int packetQueueCapacity = ConfigUtils.getInt((ConfigurationService)cfg, (String)PACKET_QUEUE_CAPACITY_PNAME, (int)-1);
        if (packetQueueCapacity == -1) {
            String oldPropertyName = "org.jitsi.impl.neomedia.MaxPacketsPerMillisPolicy.PACKET_QUEUE_CAPACITY";
            packetQueueCapacity = ConfigUtils.getInt((ConfigurationService)cfg, (String)oldPropertyName, (int)-1);
        }
        int n = PACKET_QUEUE_CAPACITY = packetQueueCapacity >= 0 ? packetQueueCapacity : 1024;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialized configuration. Send thread: " + USE_SEND_THREAD + ". Pool capacity: " + POOL_CAPACITY + ". Queue capacity: " + PACKET_QUEUE_CAPACITY + ". Avg bitrate window: " + AVERAGE_BITRATE_WINDOW_MS));
        }
    }

    private class Queue {
        final ArrayBlockingQueue<Buffer> queue = new ArrayBlockingQueue(PACKET_QUEUE_CAPACITY);
        final ArrayBlockingQueue<Buffer> pool = new ArrayBlockingQueue(15);
        int maxBuffers = -1;
        long perNanos = -1L;
        long buffersProcessedInCurrentInterval = 0L;
        long intervalStartTimeNanos = 0L;
        final Thread sendThread;
        QueueStatistics queueStats = null;

        private Queue() {
            if (logger.isTraceEnabled()) {
                this.queueStats = new QueueStatistics(PACKET_QUEUE_CAPACITY, Clock.systemUTC());
            }
            this.sendThread = new Thread(this::runInSendThread);
            this.sendThread.setDaemon(true);
            this.sendThread.setName(Queue.class.getName() + ".sendThread");
            RTPConnectorInputStream.setThreadPriority(this.sendThread, MediaThread.getNetworkPriority());
            this.sendThread.start();
        }

        private void write(byte[] buf, int off, int len, Object context) {
            Buffer b;
            if (RTPConnectorOutputStream.this.closed) {
                return;
            }
            Buffer buffer = this.getBuffer(len);
            System.arraycopy(buf, off, buffer.buf, 0, len);
            buffer.len = len;
            buffer.context = context;
            if (this.queue.size() >= PACKET_QUEUE_CAPACITY && (b = this.queue.poll()) != null) {
                if (this.queueStats != null) {
                    this.queueStats.dropped();
                }
                this.pool.offer(b);
                ++RTPConnectorOutputStream.this.numDroppedPackets;
                if (RTPConnectorOutputStream.logDroppedPacket(RTPConnectorOutputStream.this.numDroppedPackets)) {
                    logger.warn((Object)("Packets dropped (hashCode=" + this.hashCode() + "): " + RTPConnectorOutputStream.this.numDroppedPackets));
                }
            }
            if (this.queue.offer(buffer) && this.queueStats != null) {
                this.queueStats.added();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInSendThread() {
            if (!Thread.currentThread().equals(this.sendThread)) {
                logger.warn((Object)("runInSendThread executing in the wrong thread: " + Thread.currentThread().getName()), new Throwable());
                return;
            }
            try {
                while (!RTPConnectorOutputStream.this.closed) {
                    RawPacket[] pkts;
                    Buffer buffer;
                    try {
                        buffer = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException iex) {
                        continue;
                    }
                    if (RTPConnectorOutputStream.this.closed) {
                        break;
                    }
                    if (buffer == null) continue;
                    if (this.queueStats != null) {
                        this.queueStats.removed(this.queue.size(), null);
                    }
                    try {
                        pkts = RTPConnectorOutputStream.this.packetize(buffer.buf, 0, buffer.len, buffer.context);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to handle an outgoing packet: ", (Throwable)e);
                        continue;
                    }
                    finally {
                        this.pool.offer(buffer);
                        continue;
                    }
                    if (this.perNanos > 0L && this.maxBuffers > 0) {
                        long time = System.nanoTime();
                        long nanosRemainingTime = time - this.intervalStartTimeNanos;
                        if (nanosRemainingTime >= this.perNanos) {
                            this.intervalStartTimeNanos = time;
                            this.buffersProcessedInCurrentInterval = 0L;
                        } else if (this.buffersProcessedInCurrentInterval >= (long)this.maxBuffers) {
                            LockSupport.parkNanos(nanosRemainingTime);
                        }
                    }
                    try {
                        RTPConnectorOutputStream.this.write(pkts);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to send a packet: ", (Throwable)e);
                        continue;
                    }
                    ++this.buffersProcessedInCurrentInterval;
                }
            }
            finally {
                this.queue.clear();
            }
        }

        public void setMaxPacketsPerMillis(int maxPackets, long perMillis) {
            if (maxPackets < 1) {
                this.maxBuffers = -1;
                this.perNanos = -1L;
            } else {
                if (perMillis < 1L) {
                    throw new IllegalArgumentException("perMillis");
                }
                this.maxBuffers = maxPackets;
                this.perNanos = perMillis * 1000000L;
            }
        }

        private Buffer getBuffer(int len) {
            Buffer buffer = this.pool.poll();
            if (buffer == null) {
                buffer = new Buffer();
            }
            if (buffer.buf == null || buffer.buf.length < len) {
                buffer.buf = new byte[len];
            }
            return buffer;
        }

        private class Buffer {
            byte[] buf;
            int len;
            Object context;

            private Buffer() {
            }
        }
    }
}

