/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.jitsi.impl.neomedia.transform.TransformInputStream;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.utils.logging.Logger;

public class RTPConnectorUDPInputStream
extends TransformInputStream<DatagramSocket> {
    private static final Logger logger = Logger.getLogger(RTPConnectorUDPInputStream.class);

    public RTPConnectorUDPInputStream(DatagramSocket socket) {
        super(socket);
    }

    @Override
    protected void doLogPacket(DatagramPacket p) {
        if (((DatagramSocket)this.socket).getLocalAddress() == null) {
            return;
        }
        PacketLoggingService pktLogging = this.getPacketLoggingService();
        if (pktLogging != null) {
            pktLogging.logPacket(PacketLoggingService.ProtocolName.RTP, p.getAddress().getAddress(), p.getPort(), ((DatagramSocket)this.socket).getLocalAddress().getAddress(), ((DatagramSocket)this.socket).getLocalPort(), PacketLoggingService.TransportName.UDP, false, p.getData(), p.getOffset(), p.getLength());
        }
    }

    @Override
    protected void receive(DatagramPacket p) throws IOException {
        ((DatagramSocket)this.socket).receive(p);
    }

    @Override
    protected void setReceiveBufferSize(int receiveBufferSize) throws IOException {
        ((DatagramSocket)this.socket).setReceiveBufferSize(receiveBufferSize);
        logger.info((Object)("Receive buffer size updated: " + ((DatagramSocket)this.socket).getReceiveBufferSize()));
    }
}

