/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.media.MediaLocator;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.protocol.BufferTransferHandler;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.WASAPISystem;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.HResultException;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.IMediaBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPI;
import org.jitsi.impl.neomedia.jmfext.media.protocol.wasapi.WASAPIStream;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.AbstractAudioRenderer;
import org.jitsi.impl.neomedia.jmfext.media.renderer.audio.WASAPIRenderer;
import org.jitsi.utils.logging.Logger;

public class AudioCaptureClient {
    private static final Logger logger = Logger.getLogger(AudioCaptureClient.class);
    private byte[] available;
    private int availableLength;
    private int bufferFrames;
    final int bufferSize;
    private boolean busy;
    final long devicePeriod;
    private int dstChannels;
    private int dstFrameSize;
    private int dstSampleSize;
    private long eventHandle;
    private Runnable eventHandleCmd;
    private Executor eventHandleExecutor;
    private long iAudioCaptureClient;
    private long iAudioClient;
    final AudioFormat outFormat;
    private boolean read;
    private int srcChannels;
    private int srcSampleSize;
    private boolean started;
    private final BufferTransferHandler transferHandler;

    private static int maybeIAudioCaptureClientGetNextPacketSize(long iAudioCaptureClient) {
        int numFramesInNextPacket;
        try {
            numFramesInNextPacket = WASAPI.IAudioCaptureClient_GetNextPacketSize(iAudioCaptureClient);
        }
        catch (HResultException hre) {
            numFramesInNextPacket = 0;
            logger.error((Object)"IAudioCaptureClient_GetNextPacketSize", (Throwable)hre);
        }
        return numFramesInNextPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioCaptureClient(WASAPISystem audioSystem, MediaLocator locator, AudioSystem.DataFlow dataFlow, int streamFlags, long hnsBufferDuration, AudioFormat outFormat, BufferTransferHandler transferHandler) throws Exception {
        AudioFormat[] formats = WASAPISystem.getFormatsToInitializeIAudioClient(outFormat);
        long eventHandle = WASAPI.CreateEvent(0L, false, false, null);
        if (eventHandle == 0L) {
            throw new IOException("CreateEvent");
        }
        try {
            long iAudioClient = audioSystem.initializeIAudioClient(locator, dataFlow, streamFlags, eventHandle, hnsBufferDuration, formats);
            if (iAudioClient == 0L) {
                throw new ResourceUnavailableException("Failed to initialize IAudioClient for MediaLocator " + locator + " and AudioSystem.DataFlow " + dataFlow);
            }
            try {
                long iAudioCaptureClient;
                AudioFormat inFormat = null;
                for (AudioFormat aFormat : formats) {
                    if (aFormat == null) continue;
                    inFormat = aFormat;
                    break;
                }
                if ((iAudioCaptureClient = WASAPI.IAudioClient_GetService(iAudioClient, "{c8adbd64-e71e-48a0-a4de-185c395cd317}")) == 0L) {
                    throw new ResourceUnavailableException("IAudioClient_GetService(IID_IAudioCaptureClient)");
                }
                try {
                    long devicePeriod = WASAPI.IAudioClient_GetDefaultDevicePeriod(iAudioClient) / 10000L;
                    int numBufferFrames = WASAPI.IAudioClient_GetBufferSize(iAudioClient);
                    int sampleRate = (int)inFormat.getSampleRate();
                    long bufferDuration = numBufferFrames * 1000 / sampleRate;
                    if (devicePeriod <= 1L && ((devicePeriod = bufferDuration / 2L) > 10L || devicePeriod <= 1L)) {
                        devicePeriod = 10L;
                    }
                    this.devicePeriod = devicePeriod;
                    if (hnsBufferDuration == -1L) {
                        hnsBufferDuration = devicePeriod;
                    }
                    this.srcChannels = inFormat.getChannels();
                    this.srcSampleSize = WASAPISystem.getSampleSizeInBytes(inFormat);
                    this.dstChannels = outFormat.getChannels();
                    this.dstSampleSize = WASAPISystem.getSampleSizeInBytes(outFormat);
                    this.dstFrameSize = this.dstSampleSize * this.dstChannels;
                    this.bufferFrames = (int)(hnsBufferDuration * (long)sampleRate / 1000L);
                    this.bufferSize = this.dstFrameSize * this.bufferFrames;
                    this.available = new byte[numBufferFrames * this.dstFrameSize];
                    this.availableLength = 0;
                    this.eventHandle = eventHandle;
                    eventHandle = 0L;
                    this.iAudioClient = iAudioClient;
                    iAudioClient = 0L;
                    this.iAudioCaptureClient = iAudioCaptureClient;
                    iAudioCaptureClient = 0L;
                    this.outFormat = outFormat;
                    this.transferHandler = transferHandler;
                }
                finally {
                    if (iAudioCaptureClient != 0L) {
                        WASAPI.IAudioCaptureClient_Release(iAudioCaptureClient);
                    }
                }
            }
            finally {
                if (iAudioClient != 0L) {
                    WASAPI.IAudioClient_Release(iAudioClient);
                }
            }
        }
        finally {
            if (eventHandle != 0L) {
                WASAPI.CloseHandle(eventHandle);
            }
        }
    }

    public void close() {
        if (this.iAudioCaptureClient != 0L) {
            WASAPI.IAudioCaptureClient_Release(this.iAudioCaptureClient);
            this.iAudioCaptureClient = 0L;
        }
        if (this.iAudioClient != 0L) {
            WASAPI.IAudioClient_Release(this.iAudioClient);
            this.iAudioClient = 0L;
        }
        if (this.eventHandle != 0L) {
            try {
                WASAPI.CloseHandle(this.eventHandle);
            }
            catch (HResultException hre) {
                logger.warn((Object)"Failed to close event HANDLE.", (Throwable)hre);
            }
            this.eventHandle = 0L;
        }
        this.available = null;
        this.availableLength = 0;
        this.started = false;
    }

    private int doRead(IMediaBuffer iMediaBuffer, byte[] buffer, int offset, int length) throws IOException {
        int read;
        int toRead = Math.min(length, this.availableLength);
        if (toRead == 0) {
            read = 0;
        } else {
            if (iMediaBuffer == null) {
                read = toRead;
                System.arraycopy(this.available, 0, buffer, offset, toRead);
            } else {
                read = iMediaBuffer.push(this.available, 0, toRead);
            }
            this.popFromAvailable(read);
        }
        return read;
    }

    int getAvailableLength() {
        return this.availableLength;
    }

    private void popFromAvailable(int length) {
        this.availableLength = WASAPIRenderer.pop(this.available, this.availableLength, length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.read(null, buffer, offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(IMediaBuffer iMediaBuffer, byte[] buffer, int offset, int length) throws IOException {
        Throwable cause;
        int read;
        String message;
        AudioCaptureClient audioCaptureClient = this;
        synchronized (audioCaptureClient) {
            if (this.iAudioClient == 0L || this.iAudioCaptureClient == 0L) {
                message = this.getClass().getName() + " is disconnected.";
            } else if (!this.started) {
                message = this.getClass().getName() + " is stopped.";
            } else {
                message = null;
                this.busy = true;
            }
        }
        if (message != null) {
            throw new IOException(message);
        }
        try {
            read = this.doRead(iMediaBuffer, buffer, offset, length);
            cause = null;
            if (read > 0) {
                this.read = true;
            }
        }
        catch (Throwable t) {
            read = 0;
            cause = t;
        }
        finally {
            AudioCaptureClient audioCaptureClient2 = this;
            synchronized (audioCaptureClient2) {
                this.busy = false;
                this.notifyAll();
            }
        }
        if (cause != null) {
            if (cause instanceof ThreadDeath) {
                throw (ThreadDeath)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            IOException ioe = new IOException();
            ioe.initCause(cause);
            throw ioe;
        }
        return read;
    }

    public int read(IMediaBuffer iMediaBuffer, int length) throws IOException {
        return this.read(iMediaBuffer, null, 0, length);
    }

    private BufferTransferHandler readInEventHandleCmd() {
        int numFramesInNextPacket = AudioCaptureClient.maybeIAudioCaptureClientGetNextPacketSize(this.iAudioCaptureClient);
        if (numFramesInNextPacket != 0) {
            int toRead = numFramesInNextPacket * this.dstFrameSize;
            int toPop = toRead - (this.available.length - this.availableLength);
            if (toPop > 0) {
                this.popFromAvailable(toPop);
            }
            try {
                int read = WASAPI.IAudioCaptureClient_Read(this.iAudioCaptureClient, this.available, this.availableLength, toRead, this.srcSampleSize, this.srcChannels, this.dstSampleSize, this.dstChannels);
                this.availableLength += read;
            }
            catch (HResultException hre) {
                logger.error((Object)"IAudioCaptureClient_Read", (Throwable)hre);
            }
        }
        return this.availableLength >= this.bufferSize ? this.transferHandler : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runInEventHandleCmd(Runnable eventHandleCmd) {
        try {
            AbstractAudioRenderer.useAudioThreadPriority();
            while (true) {
                int wfso;
                int numFramesInNextPacket;
                BufferTransferHandler transferHandler;
                long eventHandle;
                AudioCaptureClient audioCaptureClient = this;
                synchronized (audioCaptureClient) {
                    if (!eventHandleCmd.equals(this.eventHandleCmd)) {
                        return;
                    }
                    if (this.iAudioClient == 0L || this.iAudioCaptureClient == 0L || !this.started) {
                        return;
                    }
                    eventHandle = this.eventHandle;
                    if (eventHandle == 0L) {
                        throw new IllegalStateException("eventHandle");
                    }
                    this.waitWhileBusy();
                    this.busy = true;
                }
                try {
                    transferHandler = this.readInEventHandleCmd();
                    if (transferHandler != null) {
                        this.read = false;
                    }
                    numFramesInNextPacket = AudioCaptureClient.maybeIAudioCaptureClientGetNextPacketSize(this.iAudioCaptureClient);
                }
                finally {
                    audioCaptureClient = this;
                    synchronized (audioCaptureClient) {
                        this.busy = false;
                        this.notifyAll();
                    }
                }
                if (transferHandler != null) {
                    try {
                        transferHandler.transferData(null);
                        if (this.read) {
                            continue;
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.error((Object)"BufferTransferHandler.transferData", t);
                    }
                }
                if (numFramesInNextPacket != 0) continue;
                try {
                    wfso = WASAPI.WaitForSingleObject(eventHandle, this.devicePeriod);
                }
                catch (HResultException hre) {
                    wfso = -1;
                    logger.error((Object)"WaitForSingleObject", (Throwable)hre);
                }
                if (wfso == -1) return;
                if (wfso == 128) return;
            }
        }
        finally {
            AudioCaptureClient audioCaptureClient = this;
            synchronized (audioCaptureClient) {
                if (eventHandleCmd.equals(this.eventHandleCmd)) {
                    this.eventHandleCmd = null;
                    this.notifyAll();
                }
            }
        }
    }

    public synchronized void start() throws IOException {
        block8: {
            if (this.iAudioClient != 0L) {
                this.waitWhileBusy();
                this.waitWhileEventHandleCmd();
                try {
                    WASAPI.IAudioClient_Start(this.iAudioClient);
                    this.started = true;
                    this.availableLength = 0;
                    if (this.eventHandle == 0L || this.eventHandleCmd != null) break block8;
                    Runnable eventHandleCmd = new Runnable(){

                        @Override
                        public void run() {
                            AudioCaptureClient.this.runInEventHandleCmd(this);
                        }
                    };
                    boolean submitted = false;
                    try {
                        if (this.eventHandleExecutor == null) {
                            this.eventHandleExecutor = Executors.newSingleThreadExecutor();
                        }
                        this.eventHandleCmd = eventHandleCmd;
                        this.eventHandleExecutor.execute(eventHandleCmd);
                        submitted = true;
                    }
                    finally {
                        if (!submitted && eventHandleCmd.equals(this.eventHandleCmd)) {
                            this.eventHandleCmd = null;
                        }
                    }
                }
                catch (HResultException hre) {
                    if (hre.getHResult() == WASAPI.AUDCLNT_E_NOT_STOPPED) break block8;
                    WASAPIStream.throwNewIOException("IAudioClient_Start", hre);
                }
            }
        }
    }

    public synchronized void stop() throws IOException {
        if (this.iAudioClient != 0L) {
            this.waitWhileBusy();
            try {
                WASAPI.IAudioClient_Stop(this.iAudioClient);
                this.started = false;
                this.waitWhileEventHandleCmd();
                this.availableLength = 0;
            }
            catch (HResultException hre) {
                WASAPIStream.throwNewIOException("IAudioClient_Stop", hre);
            }
        }
    }

    private synchronized void waitWhileBusy() {
        boolean interrupted = false;
        while (this.busy) {
            try {
                this.wait(this.devicePeriod);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private synchronized void waitWhileEventHandleCmd() {
        if (this.eventHandle == 0L) {
            throw new IllegalStateException("eventHandle");
        }
        boolean interrupted = false;
        while (this.eventHandleCmd != null) {
            try {
                this.wait(this.devicePeriod);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

