/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.remotebitrateestimator;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.AimdRateControl;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.InterArrival;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OveruseDetector;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.OveruseEstimator;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RateControlInput;
import org.jitsi.impl.neomedia.rtp.remotebitrateestimator.RemoteBitrateObserver;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.stats.RateStatistics;

public class RemoteBitrateEstimatorAbsSendTime
implements RemoteBitrateEstimator {
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(RemoteBitrateEstimatorAbsSendTime.class);
    private static final int kAbsSendTimeFraction = 18;
    private static final int kAbsSendTimeInterArrivalUpshift = 8;
    private static final int kTimestampGroupLengthMs = 5;
    private static final int kInterArrivalShift = 26;
    private static final long kTimestampGroupLengthTicks = 335544L;
    private static final double kTimestampToMs = 1.4901161193847656E-5;
    private final long[] deltas = new long[3];
    private final RateControlInput input = new RateControlInput(BandwidthUsage.kBwNormal, 0L, 0.0);
    private Collection<Long> ssrcs = Collections.emptyList();
    private final Map<Long, Long> ssrcsMap = new TreeMap<Long, Long>();
    private long firstPacketTimeMs;
    private long lastUpdateMs;
    private final RemoteBitrateObserver observer;
    private final AimdRateControl remoteRate;
    private Detector detector;
    private RateStatistics incomingBitrate;
    private boolean incomingBitrateInitialized;
    private final DiagnosticContext diagnosticContext;

    public RemoteBitrateEstimatorAbsSendTime(RemoteBitrateObserver observer, @NotNull DiagnosticContext diagnosticContext) {
        this.observer = observer;
        this.diagnosticContext = diagnosticContext;
        this.remoteRate = new AimdRateControl(diagnosticContext);
        this.incomingBitrate = new RateStatistics(1000, 8000.0f);
        this.incomingBitrateInitialized = false;
        this.firstPacketTimeMs = -1L;
        this.lastUpdateMs = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incomingPacketInfo(long arrivalTimeMs, long sendTime24bits, int payloadSize, long ssrc) {
        long incomingBitrate_;
        long timestamp = sendTime24bits << 8;
        long sendTimeMs = (long)((double)timestamp * 1.4901161193847656E-5);
        long nowMs = System.currentTimeMillis();
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("in_pkt", nowMs).addField("rbe_id", (Object)this.hashCode()).addField("recv_ts_ms", (Object)arrivalTimeMs).addField("send_ts_ms", (Object)sendTimeMs).addField("pkt_sz_bytes", (Object)payloadSize).addField("ssrc", (Object)ssrc));
        }
        if ((incomingBitrate_ = this.incomingBitrate.getRate(arrivalTimeMs)) != 0L) {
            this.incomingBitrateInitialized = true;
        } else if (this.incomingBitrateInitialized) {
            this.incomingBitrate = new RateStatistics(1000, 8000.0f);
            this.incomingBitrateInitialized = false;
        }
        this.incomingBitrate.update(payloadSize, arrivalTimeMs);
        if (this.firstPacketTimeMs == -1L) {
            this.firstPacketTimeMs = nowMs;
        }
        boolean updateEstimate = false;
        long targetBitrateBps = 0L;
        RemoteBitrateEstimatorAbsSendTime remoteBitrateEstimatorAbsSendTime = this;
        synchronized (remoteBitrateEstimatorAbsSendTime) {
            long incomingRate_;
            this.timeoutStreams(nowMs);
            this.ssrcsMap.put(ssrc, nowMs);
            if (!this.ssrcs.contains(ssrc)) {
                this.ssrcs = Collections.unmodifiableCollection(this.ssrcsMap.keySet());
            }
            long[] deltas = this.deltas;
            deltas[0] = 0L;
            deltas[1] = 0L;
            deltas[2] = 0L;
            if (this.detector == null) {
                this.detector = new Detector(new OverUseDetectorOptions(), true);
            }
            if (this.detector.interArrival.computeDeltas(timestamp, arrivalTimeMs, payloadSize, deltas, nowMs)) {
                double tsDeltaMs = (double)deltas[0] * 1.4901161193847656E-5;
                this.detector.estimator.update(deltas[1], tsDeltaMs, (int)deltas[2], this.detector.detector.getState(), nowMs);
                this.detector.detector.detect(this.detector.estimator.getOffset(), tsDeltaMs, this.detector.estimator.getNumOfDeltas(), arrivalTimeMs);
            }
            if (this.lastUpdateMs == -1L || nowMs - this.lastUpdateMs > this.remoteRate.getFeedBackInterval()) {
                updateEstimate = true;
            } else if (this.detector.detector.getState() == BandwidthUsage.kBwOverusing && (incomingRate_ = this.incomingBitrate.getRate(arrivalTimeMs)) > 0L && this.remoteRate.isTimeToReduceFurther(nowMs, incomingBitrate_)) {
                updateEstimate = true;
            }
            if (updateEstimate) {
                this.input.bwState = this.detector.detector.getState();
                this.input.incomingBitRate = this.incomingBitrate.getRate(arrivalTimeMs);
                this.input.noiseVar = this.detector.estimator.getVarNoise();
                this.remoteRate.update(this.input, nowMs);
                targetBitrateBps = this.remoteRate.updateBandwidthEstimate(nowMs);
                updateEstimate = this.remoteRate.isValidEstimate();
            }
        }
        if (updateEstimate) {
            this.lastUpdateMs = nowMs;
            if (this.observer != null) {
                this.observer.onReceiveBitrateChanged(this.getSsrcs(), targetBitrateBps);
            }
        }
    }

    private synchronized void timeoutStreams(long nowMs) {
        boolean removed = false;
        Iterator<Map.Entry<Long, Long>> itr = this.ssrcsMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Long, Long> entry = itr.next();
            if (nowMs - entry.getValue() <= 2000L) continue;
            removed = true;
            itr.remove();
        }
        if (removed) {
            this.ssrcs = Collections.unmodifiableCollection(this.ssrcsMap.keySet());
        }
        if (this.detector != null && this.ssrcsMap.isEmpty()) {
            this.detector = null;
        }
    }

    @Override
    public synchronized void onRttUpdate(long avgRttMs, long maxRttMs) {
        if (timeSeriesLogger.isTraceEnabled()) {
            timeSeriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("new_rtt", System.currentTimeMillis()).addField("avg_ms", (Object)avgRttMs).addField("max_ms", (Object)maxRttMs));
        }
        this.remoteRate.setRtt(avgRttMs);
    }

    @Override
    public synchronized long getLatestEstimate() {
        if (!this.remoteRate.isValidEstimate()) {
            return -1L;
        }
        long bitrateBps = this.ssrcsMap.isEmpty() ? 0L : this.remoteRate.getLatestEstimate();
        return bitrateBps;
    }

    @Override
    public Collection<Long> getSsrcs() {
        return this.ssrcs;
    }

    @Override
    public synchronized void removeStream(long ssrc) {
        if (this.ssrcsMap.remove(ssrc) != null) {
            this.ssrcs = Collections.unmodifiableCollection(this.ssrcsMap.keySet());
        }
    }

    @Override
    public synchronized void setMinBitrate(int minBitrateBps) {
        this.remoteRate.setMinBitrate(minBitrateBps);
    }

    public static long convertMsTo24Bits(long timeMs) {
        return ((timeMs << 18) + 500L) / 1000L & 0xFFFFFFL;
    }

    private class Detector {
        private InterArrival interArrival;
        private OveruseEstimator estimator;
        private final OveruseDetector detector;

        Detector(OverUseDetectorOptions options, boolean enableBurstGrouping) {
            this.interArrival = new InterArrival(335544L, 1.4901161193847656E-5, enableBurstGrouping, RemoteBitrateEstimatorAbsSendTime.this.diagnosticContext);
            this.estimator = new OveruseEstimator(options, RemoteBitrateEstimatorAbsSendTime.this.diagnosticContext);
            this.detector = new OveruseDetector(options, RemoteBitrateEstimatorAbsSendTime.this.diagnosticContext);
        }
    }
}

