/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.stats;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.MediaStreamStatsImpl;
import org.jitsi.impl.neomedia.stats.AbstractTrackStats;
import org.jitsi.impl.neomedia.stats.ReceiveTrackStatsImpl;
import org.jitsi.impl.neomedia.stats.SendTrackStatsImpl;
import org.jitsi.service.neomedia.stats.MediaStreamStats2;
import org.jitsi.service.neomedia.stats.ReceiveTrackStats;
import org.jitsi.service.neomedia.stats.SendTrackStats;
import org.jitsi.utils.logging.Logger;

public class MediaStreamStats2Impl
extends MediaStreamStatsImpl
implements MediaStreamStats2 {
    private static int INTERVAL = 1000;
    private static final Logger logger = Logger.getLogger(MediaStreamStatsImpl.class);
    private final Map<Long, ReceiveTrackStatsImpl> receiveSsrcStats = new ConcurrentHashMap<Long, ReceiveTrackStatsImpl>();
    private final Map<Long, SendTrackStatsImpl> sendSsrcStats = new ConcurrentHashMap<Long, SendTrackStatsImpl>();
    private final Map<Long, Long> sendSsrcStatsToClean = new ConcurrentHashMap<Long, Long>();
    private final AggregateReceiveTrackStats receiveStats = new AggregateReceiveTrackStats(INTERVAL, (Map<Long, ? extends ReceiveTrackStats>)this.receiveSsrcStats);
    private final AggregateSendTrackStats sendStats = new AggregateSendTrackStats(INTERVAL, (Map<Long, ? extends SendTrackStats>)this.sendSsrcStats);

    public MediaStreamStats2Impl(MediaStreamImpl mediaStream) {
        super(mediaStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtpPacketReceived(long ssrc, int seq, int length) {
        AggregateReceiveTrackStats aggregateReceiveTrackStats = this.receiveStats;
        synchronized (aggregateReceiveTrackStats) {
            this.getReceiveStats(ssrc).rtpPacketReceived(seq, length);
            this.receiveStats.packetProcessed(length, System.currentTimeMillis(), true);
        }
    }

    public void rtpPacketRetransmitted(long ssrc, long length) {
        this.getSendStats(ssrc).rtpPacketRetransmitted(length);
        this.sendStats.rtpPacketRetransmitted(length);
    }

    public void rtpPacketNotRetransmitted(long ssrc, long length) {
        this.getSendStats(ssrc).rtpPacketNotRetransmitted(length);
        this.sendStats.rtpPacketNotRetransmitted(length);
    }

    public void rtpPacketCacheMiss(long ssrc) {
        this.getSendStats(ssrc).rtpPacketCacheMiss();
        this.sendStats.rtpPacketCacheMiss();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtpPacketSent(long ssrc, int seq, int length, boolean skipStats) {
        if (skipStats) {
            return;
        }
        AggregateSendTrackStats aggregateSendTrackStats = this.sendStats;
        synchronized (aggregateSendTrackStats) {
            this.getSendStats(ssrc).rtpPacketSent(seq, length);
            this.sendStats.packetProcessed(length, System.currentTimeMillis(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpReceiverReportReceived(long ssrc, int fractionLost) {
        AggregateSendTrackStats aggregateSendTrackStats = this.sendStats;
        synchronized (aggregateSendTrackStats) {
            this.getSendStats(ssrc).rtcpReceiverReportReceived(fractionLost);
        }
        this.cleanSendStatsOld();
    }

    private void cleanSendStatsOld() {
        if (this.sendSsrcStatsToClean.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        this.sendSsrcStatsToClean.entrySet().stream().forEach(entry -> {
            if ((Long)entry.getValue() > now) {
                this.sendSsrcStats.remove(entry.getKey());
                this.sendSsrcStatsToClean.remove(entry.getKey());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpPacketReceived(long ssrc, int length) {
        AggregateReceiveTrackStats aggregateReceiveTrackStats = this.receiveStats;
        synchronized (aggregateReceiveTrackStats) {
            this.getReceiveStats(ssrc).rtcpPacketReceived(length);
            this.receiveStats.packetProcessed(length, System.currentTimeMillis(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rtcpPacketSent(long ssrc, int length) {
        AggregateSendTrackStats aggregateSendTrackStats = this.sendStats;
        synchronized (aggregateSendTrackStats) {
            this.getSendStats(ssrc).rtcpPacketSent(length);
            this.sendStats.packetProcessed(length, System.currentTimeMillis(), false);
        }
    }

    public void updateJitter(long ssrc, MediaStreamStatsImpl.StreamDirection direction, double jitter) {
        if (direction == MediaStreamStatsImpl.StreamDirection.DOWNLOAD) {
            this.receiveStats.setJitter(jitter);
            ReceiveTrackStatsImpl receiveSsrcStat = this.receiveSsrcStats.get(ssrc);
            if (receiveSsrcStat != null) {
                receiveSsrcStat.setJitter(jitter);
            }
        } else if (direction == MediaStreamStatsImpl.StreamDirection.UPLOAD) {
            this.sendStats.setJitter(jitter);
            SendTrackStatsImpl sendSsrcStat = this.sendSsrcStats.get(ssrc);
            if (sendSsrcStat != null) {
                sendSsrcStat.setJitter(jitter);
            }
        }
    }

    public void updateRtt(long ssrc, long rtt) {
        SendTrackStatsImpl sendSsrcStat;
        this.receiveStats.setRtt(rtt);
        this.sendStats.setRtt(rtt);
        if (ssrc < 0L) {
            return;
        }
        ReceiveTrackStatsImpl receiveSsrcStat = this.receiveSsrcStats.get(ssrc);
        if (receiveSsrcStat != null) {
            receiveSsrcStat.setRtt(rtt);
        }
        if ((sendSsrcStat = this.sendSsrcStats.get(ssrc)) != null) {
            sendSsrcStat.setRtt(rtt);
        }
    }

    @Override
    public ReceiveTrackStats getReceiveStats() {
        return this.receiveStats;
    }

    @Override
    public SendTrackStats getSendStats() {
        return this.sendStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReceiveTrackStatsImpl getReceiveStats(long ssrc) {
        ReceiveTrackStatsImpl stats;
        if (ssrc < 0L) {
            logger.error((Object)("No received stats for an invalid SSRC: " + ssrc));
            ssrc = -1L;
        }
        if ((stats = this.receiveSsrcStats.get(ssrc)) == null) {
            Map<Long, ReceiveTrackStatsImpl> map = this.receiveSsrcStats;
            synchronized (map) {
                stats = this.receiveSsrcStats.get(ssrc);
                if (stats == null) {
                    stats = new ReceiveTrackStatsImpl(INTERVAL, ssrc);
                    this.receiveSsrcStats.put(ssrc, stats);
                }
            }
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendTrackStatsImpl getSendStats(long ssrc) {
        SendTrackStatsImpl stats;
        if (ssrc < 0L) {
            logger.error((Object)("No send stats for an invalid SSRC: " + ssrc));
            ssrc = -1L;
        }
        if ((stats = this.sendSsrcStats.get(ssrc)) == null) {
            Map<Long, SendTrackStatsImpl> map = this.sendSsrcStats;
            synchronized (map) {
                stats = this.sendSsrcStats.get(ssrc);
                if (stats == null) {
                    stats = new SendTrackStatsImpl(INTERVAL, ssrc);
                    this.sendSsrcStats.put(ssrc, stats);
                }
            }
        }
        return stats;
    }

    @Override
    public Collection<? extends SendTrackStats> getAllSendStats() {
        return this.sendSsrcStats.values();
    }

    @Override
    public Collection<? extends ReceiveTrackStats> getAllReceiveStats() {
        return this.receiveSsrcStats.values();
    }

    public void removeReceiveSsrc(long ssrc) {
        this.receiveSsrcStats.remove(ssrc);
    }

    @Override
    public void clearSendSsrc(long ssrc) {
        this.sendSsrcStatsToClean.put(ssrc, System.currentTimeMillis() + (long)INTERVAL);
    }

    private class AggregateReceiveTrackStats
    extends AggregateTrackStats<ReceiveTrackStats>
    implements ReceiveTrackStats {
        AggregateReceiveTrackStats(int interval, Map<Long, ? extends ReceiveTrackStats> children) {
            super(interval, children);
        }

        @Override
        public long getPacketsLost() {
            long lost = 0L;
            for (ReceiveTrackStats child : this.children.values()) {
                lost += child.getPacketsLost();
            }
            return lost;
        }

        @Override
        public long getCurrentPackets() {
            long packets = 0L;
            for (ReceiveTrackStats child : this.children.values()) {
                packets += child.getCurrentPackets();
            }
            return packets;
        }

        @Override
        public long getCurrentPacketsLost() {
            long packetsLost = 0L;
            for (ReceiveTrackStats child : this.children.values()) {
                packetsLost += child.getCurrentPacketsLost();
            }
            return packetsLost;
        }

        @Override
        public double getLossRate() {
            long lost = 0L;
            long expected = 0L;
            for (ReceiveTrackStats child : this.children.values()) {
                long childLost = child.getCurrentPacketsLost();
                expected += childLost + child.getCurrentPackets();
                lost += childLost;
            }
            return expected == 0L ? 0.0 : (double)(lost / expected);
        }
    }

    private class AggregateSendTrackStats
    extends AggregateTrackStats<SendTrackStats>
    implements SendTrackStats {
        AggregateSendTrackStats(int interval, Map<Long, ? extends SendTrackStats> children) {
            super(interval, children);
        }

        @Override
        public double getLossRate() {
            double sum = 0.0;
            int count = 0;
            for (SendTrackStats child : this.children.values()) {
                double fractionLoss = child.getLossRate();
                if (!(fractionLoss >= 0.0)) continue;
                sum += fractionLoss;
                ++count;
            }
            return count != 0 ? sum / (double)count : 0.0;
        }

        @Override
        public int getHighestSent() {
            return -1;
        }
    }

    private abstract class AggregateTrackStats<T>
    extends AbstractTrackStats {
        protected final Map<Long, ? extends T> children;

        AggregateTrackStats(int interval, Map<Long, ? extends T> children) {
            super(interval, -1L);
            this.children = children;
        }

        @Override
        protected void packetProcessed(int length, long now, boolean rtp) {
            super.packetProcessed(length, now, true);
        }
    }
}

