/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.dtls;

import java.io.IOException;
import java.util.Hashtable;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsControlImpl;
import org.jitsi.impl.neomedia.transform.dtls.DtlsPacketTransformer;
import org.jitsi.impl.neomedia.transform.dtls.DtlsUtils;
import org.jitsi.impl.neomedia.transform.dtls.Properties;
import org.jitsi.utils.logging.Logger;

public class TlsServerImpl
extends DefaultTlsServer {
    private static final Logger logger = Logger.getLogger(TlsServerImpl.class);
    private final CertificateRequest certificateRequest = new CertificateRequest(new short[]{1}, null, null);
    private int chosenProtectionProfile;
    private final DtlsPacketTransformer packetTransformer;

    public TlsServerImpl(DtlsPacketTransformer packetTransformer) {
        super((TlsCrypto)DtlsUtils.BC_TLS_CRYPTO);
        this.packetTransformer = packetTransformer;
    }

    public CertificateRequest getCertificateRequest() {
        return this.certificateRequest;
    }

    public int[] getCipherSuites() {
        int[] suites = new int[]{52392, 49200, 49199, 49192, 49191, 49172, 49171, 52394, 159, 158, 107, 103, 57, 51};
        return TlsUtils.getSupportedCipherSuites((TlsCrypto)this.getCrypto(), (int[])suites);
    }

    private DtlsControlImpl getDtlsControl() {
        return this.packetTransformer.getDtlsControl();
    }

    private Properties getProperties() {
        return this.packetTransformer.getProperties();
    }

    public Hashtable getServerExtensions() throws IOException {
        Hashtable serverExtensions = super.getServerExtensions();
        if (this.isSrtpDisabled()) {
            return serverExtensions;
        }
        if (TlsSRTPUtils.getUseSRTPExtension((Hashtable)serverExtensions) == null) {
            UseSRTPData useSRTPData;
            int chosenProtectionProfile;
            if (serverExtensions == null) {
                serverExtensions = new Hashtable();
            }
            if ((chosenProtectionProfile = DtlsControlImpl.chooseSRTPProtectionProfile((useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)this.clientExtensions)).getProtectionProfiles())) == 0) {
                String msg = "No chosen SRTP protection profile!";
                TlsFatalAlert tfa = new TlsFatalAlert(80);
                logger.error((Object)msg, (Throwable)tfa);
                throw tfa;
            }
            TlsSRTPUtils.addUseSRTPExtension(serverExtensions, (UseSRTPData)new UseSRTPData(new int[]{chosenProtectionProfile}, useSRTPData.getMki()));
            this.chosenProtectionProfile = chosenProtectionProfile;
        }
        return serverExtensions;
    }

    private boolean isSrtpDisabled() {
        return this.getProperties().isSrtpDisabled();
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        this.packetTransformer.notifyAlertRaised((TlsPeer)this, alertLevel, alertDescription, message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyHandshakeComplete() {
        if (this.packetTransformer.getProperties().isSrtpDisabled()) {
            return;
        }
        SinglePacketTransformer srtpTransformer = this.packetTransformer.initializeSRTPTransformer(this.chosenProtectionProfile, (TlsContext)this.context);
        DtlsPacketTransformer dtlsPacketTransformer = this.packetTransformer;
        synchronized (dtlsPacketTransformer) {
            this.packetTransformer.setSrtpTransformer(srtpTransformer);
        }
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        try {
            this.getDtlsControl().verifyAndValidateCertificate(clientCertificate);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to verify and/or validate client certificate!", (Throwable)e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    public void processClientExtensions(Hashtable clientExtensions) throws IOException {
        if (this.isSrtpDisabled()) {
            super.processClientExtensions(clientExtensions);
            return;
        }
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension((Hashtable)clientExtensions);
        if (useSRTPData == null) {
            String msg = "DTLS extended client hello does not include the use_srtp extension!";
            IOException ioe = new IOException(msg);
            logger.error((Object)msg, (Throwable)ioe);
            throw ioe;
        }
        int chosenProtectionProfile = DtlsControlImpl.chooseSRTPProtectionProfile(useSRTPData.getProtectionProfiles());
        if (chosenProtectionProfile == 0) {
            String msg = "No chosen SRTP protection profile!";
            TlsFatalAlert tfa = new TlsFatalAlert(47);
            logger.error((Object)msg, (Throwable)tfa);
            throw tfa;
        }
        super.processClientExtensions(clientExtensions);
    }
}

