/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.srtp;

import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;
import org.jitsi.service.neomedia.RawPacket;
import org.jitsi.srtp.SrtcpCryptoContext;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpErrorStatus;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging.Logger;

public class SRTCPTransformer
extends SinglePacketTransformer {
    private static final Logger logger = Logger.getLogger(SRTCPTransformer.class);
    private SrtpContextFactory forwardFactory;
    private SrtpContextFactory reverseFactory;
    private final Map<Integer, SrtcpCryptoContext> contexts;

    public SRTCPTransformer(SRTPTransformer srtpTransformer) {
        this(srtpTransformer.forwardFactory, srtpTransformer.reverseFactory);
    }

    public SRTCPTransformer(SrtpContextFactory factory) {
        this(factory, factory);
    }

    public SRTCPTransformer(SrtpContextFactory forwardFactory, SrtpContextFactory reverseFactory) {
        this.forwardFactory = forwardFactory;
        this.reverseFactory = reverseFactory;
        this.contexts = new HashMap<Integer, SrtcpCryptoContext>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFactory(SrtpContextFactory factory, boolean forward) {
        Map<Integer, SrtcpCryptoContext> map = this.contexts;
        synchronized (map) {
            if (forward) {
                if (this.forwardFactory != null && this.forwardFactory != factory) {
                    this.forwardFactory.close();
                }
                this.forwardFactory = factory;
            } else {
                if (this.reverseFactory != null && this.reverseFactory != factory) {
                    this.reverseFactory.close();
                }
                this.reverseFactory = factory;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<Integer, SrtcpCryptoContext> map = this.contexts;
        synchronized (map) {
            this.forwardFactory.close();
            if (this.reverseFactory != this.forwardFactory) {
                this.reverseFactory.close();
            }
            this.contexts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SrtcpCryptoContext getContext(RawPacket pkt, SrtpContextFactory engine) {
        SrtcpCryptoContext context;
        int ssrc = (int)pkt.getRTCPSSRC();
        Map<Integer, SrtcpCryptoContext> map = this.contexts;
        synchronized (map) {
            context = this.contexts.get(ssrc);
            if (context == null && engine != null) {
                try {
                    context = engine.deriveControlContext(ssrc);
                }
                catch (GeneralSecurityException e) {
                    logger.error((Object)("Could not get context for ssrc " + ssrc), (Throwable)e);
                    return null;
                }
                this.contexts.put(ssrc, context);
            }
        }
        return context;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        SrtcpCryptoContext context = this.getContext(pkt, this.reverseFactory);
        if (context == null) {
            return null;
        }
        try {
            return context.reverseTransformPacket((ByteArrayBuffer)pkt) == SrtpErrorStatus.OK ? pkt : null;
        }
        catch (GeneralSecurityException e) {
            return null;
        }
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        SrtcpCryptoContext context = this.getContext(pkt, this.forwardFactory);
        if (context != null) {
            try {
                context.transformPacket((ByteArrayBuffer)pkt);
                return pkt;
            }
            catch (GeneralSecurityException e) {
                return null;
            }
        }
        return null;
    }
}

