/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.libjitsi;

import org.jitsi.impl.libjitsi.LibJitsiImpl;
import org.jitsi.impl.libjitsi.LibJitsiOSGiImpl;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.utils.logging.Logger;
import org.osgi.framework.BundleContext;

public abstract class LibJitsi {
    private static final Logger logger = Logger.getLogger(LibJitsi.class);
    private static LibJitsi impl;

    public static AudioNotifierService getAudioNotifierService() {
        return LibJitsi.invokeGetServiceOnImpl(AudioNotifierService.class);
    }

    public static ConfigurationService getConfigurationService() {
        return LibJitsi.invokeGetServiceOnImpl(ConfigurationService.class);
    }

    public static FileAccessService getFileAccessService() {
        return LibJitsi.invokeGetServiceOnImpl(FileAccessService.class);
    }

    public static MediaService getMediaService() {
        return LibJitsi.invokeGetServiceOnImpl(MediaService.class);
    }

    public static PacketLoggingService getPacketLoggingService() {
        return LibJitsi.invokeGetServiceOnImpl(PacketLoggingService.class);
    }

    public static ResourceManagementService getResourceManagementService() {
        return LibJitsi.invokeGetServiceOnImpl(ResourceManagementService.class);
    }

    private static <T> T invokeGetServiceOnImpl(Class<T> serviceClass) {
        LibJitsi impl = LibJitsi.impl;
        if (impl == null) {
            throw new IllegalStateException("impl");
        }
        return impl.getService(serviceClass);
    }

    public static void start() {
        LibJitsi.start(null);
    }

    static LibJitsi start(BundleContext context) {
        if (null != impl) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("LibJitsi already started, using as implementation: " + impl.getClass().getCanonicalName()));
            }
            return impl;
        }
        impl = context == null ? new LibJitsiImpl() : new LibJitsiOSGiImpl(context);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Successfully started LibJitsi using as implementation: " + impl.getClass().getCanonicalName()));
        }
        return impl;
    }

    public static void stop() {
        impl = null;
    }

    protected LibJitsi() {
    }

    protected abstract <T> T getService(Class<T> var1);
}

