/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.io.Serializable;
import java.util.Iterator;
import org.jitsi.service.neomedia.ByteArrayBufferImpl;
import org.jitsi.util.RTPUtils;
import org.jitsi.utils.ByteArrayBuffer;

public class RawPacket
implements ByteArrayBuffer {
    public static final int EXT_HEADER_SIZE = 4;
    public static final int FIXED_HEADER_SIZE = 12;
    private static final int RTCP_MIN_SIZE = 8;
    public static final int SEQUENCE_NUMBER_MASK = 65535;
    public static final long TIMESTAMP_MASK = 0xFFFFFFFFL;
    private byte[] buffer;
    private int flags;
    private int length;
    private int offset;
    private HeaderExtensions headerExtensions;
    private boolean skipStats = false;

    public RawPacket() {
        this.headerExtensions = null;
    }

    public RawPacket(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
        this.headerExtensions = new HeaderExtensions();
    }

    public static int getVersion(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RawPacket.getVersion(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static int getVersion(byte[] buffer, int offset, int length) {
        return (buffer[offset] & 0xC0) >>> 6;
    }

    public static boolean isPacketMarked(ByteArrayBuffer baf) {
        if (baf == null) {
            return false;
        }
        return RawPacket.isPacketMarked(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static boolean isPacketMarked(byte[] buffer, int offset, int length) {
        if (buffer == null || buffer.length < offset + length || length < 2) {
            return false;
        }
        return (buffer[offset + 1] & 0x80) != 0;
    }

    public static boolean isInvalid(byte[] buffer, int offset, int length) {
        if (buffer == null || buffer.length < offset + length || length < 8) {
            return true;
        }
        int pt = buffer[offset + 1] & 0xFF;
        if (pt < 200 || pt > 211) {
            return length < 12;
        }
        return false;
    }

    public static long getRTCPSSRC(ByteArrayBuffer baf) {
        if (baf == null || baf.isInvalid()) {
            return -1L;
        }
        return RawPacket.getRTCPSSRC(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static long getRTCPSSRC(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 8) {
            return -1L;
        }
        return RTPUtils.readUint32AsLong(buf, off + 4);
    }

    public static boolean isRtpRtcp(byte[] buf, int off, int len) {
        if (RawPacket.isInvalid(buf, off, len)) {
            return false;
        }
        int version = RawPacket.getVersion(buf, off, len);
        return version == 2;
    }

    public void addExtension(byte id, byte[] data) {
        this.addExtension(id, data, data.length);
    }

    public void addExtension(byte id, byte[] data, int len) {
        if (data == null || len < 1 || len > 16 || data.length < len) {
            throw new IllegalArgumentException("id=" + id + " data.length=" + (Serializable)(data == null ? "null" : Integer.valueOf(data.length)) + " len=" + len);
        }
        HeaderExtension he = this.addExtension(id, len);
        System.arraycopy(data, 0, he.getBuffer(), he.getOffset() + 1, len);
    }

    public HeaderExtension addExtension(byte id, int len) {
        int newPayloadOffset;
        byte[] newBuffer;
        if (id < 1 || id > 15 || len < 1 || len > 16) {
            throw new IllegalArgumentException("id=" + id + " len=" + len);
        }
        int payloadLength = this.getPayloadLength();
        boolean extensionBit = this.getExtensionBit();
        int extHeaderOffset = 12 + 4 * this.getCsrcCount();
        int maxRequiredLength = this.getLength() + (extensionBit ? 0 : 4) + 1 + len + 3;
        if (this.buffer.length >= maxRequiredLength) {
            newBuffer = this.buffer;
            if (this.offset + this.getHeaderLength() >= maxRequiredLength - this.getPayloadLength()) {
                newPayloadOffset = this.getPayloadOffset();
            } else {
                newPayloadOffset = this.buffer.length - payloadLength;
                System.arraycopy(this.buffer, this.getPayloadOffset(), this.buffer, newPayloadOffset, payloadLength);
            }
        } else {
            newBuffer = new byte[maxRequiredLength];
            newPayloadOffset = newBuffer.length - payloadLength;
            System.arraycopy(this.buffer, this.getPayloadOffset(), newBuffer, newPayloadOffset, payloadLength);
        }
        int newHeaderLength = extHeaderOffset;
        int extensionBytes = 0;
        if (extensionBit) {
            newHeaderLength += 4;
            HeaderExtensions hes = this.getHeaderExtensions();
            while (hes.hasNext()) {
                HeaderExtension he = hes.next();
                extensionBytes += 1 + he.getExtLength();
            }
            newHeaderLength += extensionBytes;
        }
        System.arraycopy(this.buffer, this.offset, newBuffer, 0, newHeaderLength);
        if (!extensionBit) {
            RTPUtils.writeShort(newBuffer, extHeaderOffset, (short)-16674);
            newHeaderLength += 4;
        }
        newBuffer[newHeaderLength++] = (byte)((id & 0xF) << 4 | len - 1 & 0xF);
        ++extensionBytes;
        int extensionDataOffset = newHeaderLength - 1;
        newHeaderLength += len;
        int paddingBytes = (4 - (extensionBytes += len) % 4) % 4;
        for (int i = 0; i < paddingBytes; ++i) {
            newBuffer[newHeaderLength++] = 0;
        }
        RTPUtils.writeShort(newBuffer, extHeaderOffset + 2, (short)((extensionBytes + paddingBytes) / 4));
        int newOffset = newPayloadOffset - newHeaderLength;
        if (newOffset != 0) {
            System.arraycopy(newBuffer, 0, newBuffer, newOffset, newHeaderLength);
        }
        this.setBuffer(newBuffer);
        this.offset = newOffset;
        this.length = newHeaderLength + payloadLength;
        this.setExtensionBit(true);
        HeaderExtension he = this.getHeaderExtensions().headerExtension;
        he.setOffset(this.getOffset() + extensionDataOffset);
        he.setLength(len + 1);
        return he;
    }

    public void append(byte[] data, int len) {
        if (data == null || len == 0) {
            return;
        }
        this.grow(len);
        System.arraycopy(data, 0, this.buffer, this.length + this.offset, len);
        this.length += len;
    }

    public long[] extractCsrcAudioLevels(byte csrcExtID) {
        if (!this.getExtensionBit() || this.getExtensionLength() == 0) {
            return null;
        }
        int csrcCount = this.getCsrcCount();
        if (csrcCount == 0) {
            return null;
        }
        long[] csrcLevels = new long[csrcCount * 2];
        int i = 0;
        int csrcStartIndex = this.offset + 12;
        while (i < csrcCount) {
            int csrcLevelsIndex = 2 * i;
            csrcLevels[csrcLevelsIndex] = this.readUint32AsLong(csrcStartIndex);
            csrcLevels[csrcLevelsIndex + 1] = this.getCsrcAudioLevel(csrcExtID, i, (byte)0);
            ++i;
            csrcStartIndex += 4;
        }
        return csrcLevels;
    }

    public long[] extractCsrcList() {
        int csrcCount = this.getCsrcCount();
        long[] csrcList = new long[csrcCount];
        int i = 0;
        int csrcStartIndex = this.offset + 12;
        while (i < csrcCount) {
            csrcList[i] = this.readInt(csrcStartIndex);
            ++i;
            csrcStartIndex += 4;
        }
        return csrcList;
    }

    public byte extractSsrcAudioLevel(byte ssrcExtID) {
        return this.getCsrcAudioLevel(ssrcExtID, 0, (byte)-128);
    }

    private int findExtension(int extensionID) {
        int currLen;
        int extOffset;
        if (!this.getExtensionBit() || this.getExtensionLength() == 0) {
            return 0;
        }
        int extensionEnd = extOffset + this.getExtensionLength();
        int extHdrLen = this.getExtensionHeaderLength();
        if (extHdrLen != 1 && extHdrLen != 2) {
            return -1;
        }
        for (extOffset = this.offset + 12 + this.getCsrcCount() * 4 + 4; extOffset < extensionEnd; extOffset += currLen) {
            int currType = -1;
            currLen = -1;
            if (extHdrLen == 1) {
                currType = this.buffer[extOffset] >> 4;
                currLen = (this.buffer[extOffset] & 0xF) + 1;
                ++extOffset;
            } else {
                currType = this.buffer[extOffset];
                currLen = this.buffer[extOffset + 1];
                extOffset += 2;
            }
            if (currType != extensionID) continue;
            return extOffset;
        }
        return -1;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    private byte getCsrcAudioLevel(byte csrcExtID, int index, byte defaultValue) {
        byte level = defaultValue;
        try {
            int levelsCount;
            int levelsStart;
            if (this.getExtensionBit() && this.getExtensionLength() != 0 && (levelsStart = this.findExtension(csrcExtID)) != -1 && (levelsCount = this.getLengthForExtension(levelsStart)) >= index) {
                level = (byte)(0x7F & this.buffer[levelsStart + index]);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            level = defaultValue;
        }
        return level;
    }

    public int getCsrcCount() {
        return RawPacket.getCsrcCount(this.buffer, this.offset, this.length);
    }

    public static int getCsrcCount(byte[] buffer, int offset, int length) {
        int cc = buffer[offset] & 0xF;
        if (12 + cc * 4 > length) {
            cc = 0;
        }
        return cc;
    }

    public boolean getExtensionBit() {
        return RawPacket.getExtensionBit(this.buffer, this.offset, this.length);
    }

    public static boolean getExtensionBit(byte[] buffer, int offset, int length) {
        return (buffer[offset] & 0x10) == 16;
    }

    private int getExtensionHeaderLength() {
        if (!this.getExtensionBit()) {
            return -1;
        }
        int extLenIndex = this.offset + 12 + this.getCsrcCount() * 4;
        if (this.buffer[extLenIndex] == -66 && this.buffer[extLenIndex + 1] == -34) {
            return 1;
        }
        if (this.buffer[extLenIndex] == 16 && this.buffer[extLenIndex + 1] >> 4 == 0) {
            return 2;
        }
        return -1;
    }

    public int getExtensionLength() {
        return RawPacket.getExtensionLength(this.buffer, this.offset, this.length);
    }

    public HeaderExtensions getHeaderExtensions() {
        if (this.headerExtensions == null) {
            this.headerExtensions = new HeaderExtensions();
        }
        this.headerExtensions.reset();
        return this.headerExtensions;
    }

    public static int getExtensionLength(byte[] buffer, int offset, int length) {
        if (!RawPacket.getExtensionBit(buffer, offset, length)) {
            return 0;
        }
        int extLenIndex = offset + 12 + RawPacket.getCsrcCount(buffer, offset, length) * 4 + 2;
        int len = (buffer[extLenIndex] << 8 | buffer[extLenIndex + 1] & 0xFF) * 4;
        if (len < 0 || len > length - 12 - 4 - RawPacket.getCsrcCount(buffer, offset, length) * 4) {
            len = 0;
        }
        return len;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getHeaderExtensionType() {
        if (!this.getExtensionBit()) {
            return 0;
        }
        return this.readUint16AsInt(this.offset + 12 + this.getCsrcCount() * 4);
    }

    public int getHeaderLength() {
        return RawPacket.getHeaderLength(this.buffer, this.offset, this.length);
    }

    public static int getHeaderLength(byte[] buffer, int offset, int length) {
        int headerLength = 12 + 4 * RawPacket.getCsrcCount(buffer, offset, length);
        if (headerLength > length) {
            headerLength = length;
        }
        if (RawPacket.getExtensionBit(buffer, offset, length) && headerLength + 4 <= length) {
            headerLength += 4 + RawPacket.getExtensionLength(buffer, offset, length);
        }
        return headerLength;
    }

    public int getLength() {
        return this.length;
    }

    private int getLengthForExtension(int contentStart) {
        int hdrLen = this.getExtensionHeaderLength();
        if (hdrLen == 1) {
            return (this.buffer[contentStart - 1] & 0xF) + 1;
        }
        return this.buffer[contentStart - 1];
    }

    public int getOffset() {
        return this.offset;
    }

    public int getVersion() {
        return RawPacket.getVersion(this.buffer, this.offset, this.length);
    }

    public int getPaddingSize() {
        return RawPacket.getPaddingSize(this.buffer, this.offset, this.length);
    }

    public static int getPaddingSize(byte[] buf, int off, int len) {
        if ((buf[off] & 0x20) == 0) {
            return 0;
        }
        return 0xFF & buf[off + len - 1];
    }

    public byte[] getPayload() {
        return this.readRegion(this.getHeaderLength(), this.getPayloadLength());
    }

    public int getPayloadLength(boolean removePadding) {
        return RawPacket.getPayloadLength(this.buffer, this.offset, this.length, removePadding);
    }

    public int getPayloadLength() {
        return RawPacket.getPayloadLength(this.buffer, this.offset, this.length);
    }

    public static int getPayloadLength(byte[] buffer, int offset, int length) {
        return RawPacket.getPayloadLength(buffer, offset, length, false);
    }

    public static int getPayloadLength(byte[] buffer, int offset, int length, boolean removePadding) {
        int lenHeader = RawPacket.getHeaderLength(buffer, offset, length);
        if (lenHeader < 0) {
            return -1;
        }
        int len = length - lenHeader;
        if (removePadding) {
            int szPadding = RawPacket.getPaddingSize(buffer, offset, length);
            if (szPadding < 0) {
                return -1;
            }
            len -= szPadding;
        }
        return len;
    }

    public int getPayloadOffset() {
        return RawPacket.getPayloadOffset(this.buffer, this.offset, this.length);
    }

    public static int getPayloadOffset(byte[] buffer, int offset, int length) {
        return offset + RawPacket.getHeaderLength(buffer, offset, length);
    }

    public byte getPayloadType() {
        return (byte)RawPacket.getPayloadType(this.buffer, this.offset, this.length);
    }

    public static int getPayloadType(byte[] buf, int off, int len) {
        if (buf == null || buf.length < off + len || len < 2) {
            return -1;
        }
        return buf[off + 1] & 0x7F;
    }

    public static int getPayloadType(RawPacket pkt) {
        if (pkt == null) {
            return -1;
        }
        return RawPacket.getPayloadType(pkt.getBuffer(), pkt.getOffset(), pkt.getLength());
    }

    public long getRTCPSSRC() {
        return RawPacket.getRTCPSSRC(this);
    }

    public int getRTCPPacketType() {
        return 0xFF & this.buffer[this.offset + 1];
    }

    public int getSequenceNumber() {
        return RawPacket.getSequenceNumber(this.buffer, this.offset, this.length);
    }

    public static int getSequenceNumber(byte[] buffer, int offset, int length) {
        return RTPUtils.readUint16AsInt(buffer, offset + 2);
    }

    public static int getSequenceNumber(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1;
        }
        return RawPacket.getSequenceNumber(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public static void setSequenceNumber(byte[] buffer, int offset, int seq) {
        RTPUtils.writeShort(buffer, offset + 2, (short)seq);
    }

    public static void setSequenceNumber(ByteArrayBuffer baf, int dstSeqNum) {
        if (baf == null) {
            return;
        }
        RawPacket.setSequenceNumber(baf.getBuffer(), baf.getOffset(), dstSeqNum);
    }

    public static void setTimestamp(byte[] buf, int off, int len, long ts) {
        RTPUtils.writeInt(buf, off + 4, (int)ts);
    }

    public static void setTimestamp(ByteArrayBuffer baf, long ts) {
        if (baf == null) {
            return;
        }
        RawPacket.setTimestamp(baf.getBuffer(), baf.getOffset(), baf.getLength(), ts);
    }

    public int getSRTCPIndex(int authTagLen) {
        return RawPacket.getSRTCPIndex(this, authTagLen);
    }

    public static int getSRTCPIndex(ByteArrayBuffer baf, int authTagLen) {
        int authTagOffset = baf.getLength() - (4 + authTagLen);
        return RTPUtils.readInt(baf.getBuffer(), baf.getOffset() + authTagOffset);
    }

    public int getSSRC() {
        return RawPacket.getSSRC(this.buffer, this.offset, this.length);
    }

    public static int getSSRC(byte[] buffer, int offset, int length) {
        return RTPUtils.readInt(buffer, offset + 8);
    }

    public static int getSSRC(ByteArrayBuffer baf) {
        return RawPacket.getSSRC(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public long getSSRCAsLong() {
        return RawPacket.getSSRCAsLong(this.buffer, this.offset, this.length);
    }

    public static long getSSRCAsLong(byte[] buffer, int offset, int length) {
        return (long)RawPacket.getSSRC(buffer, offset, length) & 0xFFFFFFFFL;
    }

    public long getTimestamp() {
        return RawPacket.getTimestamp(this.buffer, this.offset, this.length);
    }

    public static long getTimestamp(byte[] buf, int off, int len) {
        return RTPUtils.readUint32AsLong(buf, off + 4);
    }

    public static long getTimestamp(ByteArrayBuffer baf) {
        if (baf == null) {
            return -1L;
        }
        return RawPacket.getTimestamp(baf.getBuffer(), baf.getOffset(), baf.getLength());
    }

    public void grow(int howMuch) {
        if (howMuch < 0) {
            throw new IllegalArgumentException("howMuch");
        }
        int newLength = this.length + howMuch;
        if (newLength > this.buffer.length - this.offset) {
            byte[] newBuffer = new byte[newLength];
            System.arraycopy(this.buffer, this.offset, newBuffer, 0, this.length);
            this.offset = 0;
            this.setBuffer(newBuffer);
        }
    }

    public boolean isInvalid() {
        return RawPacket.isInvalid(this.buffer, this.offset, this.length);
    }

    public boolean isPacketMarked() {
        return RawPacket.isPacketMarked(this.buffer, this.offset, this.length);
    }

    public byte readByte(int off) {
        return this.buffer[this.offset + off];
    }

    public int readInt(int off) {
        return RTPUtils.readInt(this.buffer, this.offset + off);
    }

    public long readUint32AsLong(int off) {
        return RTPUtils.readUint32AsLong(this.buffer, this.offset + off);
    }

    public byte[] readRegion(int off, int len) {
        int startOffset = this.offset + off;
        if (off < 0 || len <= 0 || startOffset + len > this.buffer.length) {
            return null;
        }
        byte[] region = new byte[len];
        System.arraycopy(this.buffer, startOffset, region, 0, len);
        return region;
    }

    public void readRegionToBuff(int off, int len, byte[] outBuff) {
        int startOffset = this.offset + off;
        if (off < 0 || len <= 0 || startOffset + len > this.buffer.length) {
            return;
        }
        if (outBuff.length < len) {
            return;
        }
        System.arraycopy(this.buffer, startOffset, outBuff, 0, len);
    }

    public void writeShort(int off, short val) {
        RTPUtils.writeShort(this.buffer, this.offset + off, val);
    }

    public int readUint16AsInt(int off) {
        return RTPUtils.readUint16AsInt(this.buffer, this.offset + off);
    }

    public void removeExtension() {
        if (!this.getExtensionBit()) {
            return;
        }
        int payloadOffset = this.offset + this.getHeaderLength();
        int extHeaderLen = this.getExtensionLength() + 4;
        System.arraycopy(this.buffer, payloadOffset, this.buffer, payloadOffset - extHeaderLen, this.getPayloadLength());
        this.length -= extHeaderLen;
        this.setExtensionBit(false);
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.headerExtensions = new HeaderExtensions();
    }

    public void setCsrcList(long[] newCsrcList) {
        int newCsrcCount = newCsrcList.length;
        byte[] csrcBuff = new byte[newCsrcCount * 4];
        int csrcOffset = 0;
        for (int i = 0; i < newCsrcList.length; ++i) {
            long csrc = newCsrcList[i];
            RTPUtils.writeInt(csrcBuff, csrcOffset, (int)csrc);
            csrcOffset += 4;
        }
        int oldCsrcCount = this.getCsrcCount();
        byte[] oldBuffer = this.getBuffer();
        byte[] newBuffer = new byte[this.length + this.offset + csrcBuff.length - oldCsrcCount * 4];
        System.arraycopy(oldBuffer, 0, newBuffer, 0, this.offset + 12);
        System.arraycopy(csrcBuff, 0, newBuffer, this.offset + 12, csrcBuff.length);
        int payloadOffsetForOldBuff = this.offset + 12 + oldCsrcCount * 4;
        int payloadOffsetForNewBuff = this.offset + 12 + newCsrcCount * 4;
        System.arraycopy(oldBuffer, payloadOffsetForOldBuff, newBuffer, payloadOffsetForNewBuff, this.length - payloadOffsetForOldBuff);
        newBuffer[this.offset] = (byte)(newBuffer[this.offset] & 0xF0 | newCsrcCount);
        this.setBuffer(newBuffer);
        this.length = payloadOffsetForNewBuff + this.length - payloadOffsetForOldBuff - this.offset;
    }

    private void setExtensionBit(boolean extBit) {
        if (extBit) {
            int n = this.offset;
            this.buffer[n] = (byte)(this.buffer[n] | 0x10);
        } else {
            int n = this.offset;
            this.buffer[n] = (byte)(this.buffer[n] & 0xEF);
        }
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setMarker(boolean marker) {
        if (marker) {
            int n = this.offset + 1;
            this.buffer[n] = (byte)(this.buffer[n] | 0xFFFFFF80);
        } else {
            int n = this.offset + 1;
            this.buffer[n] = (byte)(this.buffer[n] & 0x7F);
        }
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setPayloadType(byte payload) {
        payload = (byte)(payload & 0x7F);
        this.buffer[this.offset + 1] = (byte)(this.buffer[this.offset + 1] & 0x80 | payload);
    }

    public void setSequenceNumber(int seq) {
        RawPacket.setSequenceNumber(this.buffer, this.offset, seq);
    }

    public void setSSRC(int ssrc) {
        this.writeInt(8, ssrc);
    }

    public void setTimestamp(long timestamp) {
        RawPacket.setTimestamp(this.buffer, this.offset, this.length, timestamp);
    }

    public void shrink(int len) {
        if (len <= 0) {
            return;
        }
        this.length -= len;
        if (this.length < 0) {
            this.length = 0;
        }
    }

    public void writeByte(int off, byte b) {
        this.buffer[this.offset + off] = b;
    }

    public void writeInt(int off, int data) {
        RTPUtils.writeInt(this.buffer, this.offset + off, data);
    }

    public int getOriginalSequenceNumber() {
        return RTPUtils.readUint16AsInt(this.buffer, this.offset + this.getHeaderLength());
    }

    public void setOriginalSequenceNumber(int sequenceNumber) {
        this.writeShort(this.getHeaderLength(), (short)sequenceNumber);
    }

    public boolean setPaddingSize(int len) {
        if (this.buffer == null || this.buffer.length < this.offset + 12 + len || len < 0 || len > 255) {
            return false;
        }
        int n = this.offset;
        this.buffer[n] = (byte)(this.buffer[n] | 0x20);
        this.buffer[this.offset + this.length - 1] = (byte)len;
        return true;
    }

    public boolean setVersion() {
        if (this.isInvalid()) {
            return false;
        }
        int n = this.offset;
        this.buffer[n] = (byte)(this.buffer[n] | 0x80);
        return true;
    }

    public boolean isSkipStats() {
        return this.skipStats;
    }

    public void setSkipStats(boolean skipStats) {
        this.skipStats = skipStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RawPacket[off=").append(this.offset).append(", len=").append(this.length).append(", PT=").append(this.getPayloadType()).append(", SSRC=").append(this.getSSRCAsLong()).append(", seq=").append(this.getSequenceNumber()).append(", M=").append(this.isPacketMarked()).append(", X=").append(this.getExtensionBit()).append(", TS=").append(this.getTimestamp()).append(", hdrLen=").append(this.getHeaderLength()).append(", payloadLen=").append(this.getPayloadLength()).append(", paddingLen=").append(this.getPaddingSize()).append(", extLen=").append(this.getExtensionLength()).append(']');
        return sb.toString();
    }

    public HeaderExtension getHeaderExtension(byte id) {
        HeaderExtensions hes = this.getHeaderExtensions();
        while (hes.hasNext()) {
            HeaderExtension he = hes.next();
            if (he.getExtId() != id) continue;
            return he;
        }
        return null;
    }

    public class HeaderExtensions
    implements Iterator<HeaderExtension> {
        private int nextOff;
        private int remainingLen;
        private HeaderExtension headerExtension;

        public HeaderExtensions() {
            this.headerExtension = new HeaderExtension();
        }

        private void reset() {
            int len = RawPacket.this.getExtensionLength();
            if (len <= 0) {
                this.nextOff = -1;
                this.remainingLen = -1;
                return;
            }
            this.nextOff = RawPacket.this.offset + 12 + RawPacket.getCsrcCount(RawPacket.this.buffer, RawPacket.this.offset, RawPacket.this.length) * 4 + 4;
            this.remainingLen = len;
        }

        @Override
        public boolean hasNext() {
            if (this.remainingLen <= 0 || this.nextOff < 0) {
                return false;
            }
            int len = this.getExtLength(RawPacket.this.buffer, this.nextOff, this.remainingLen);
            return len > 0;
        }

        private int getExtLength(byte[] buf, int off, int len) {
            if (len <= 2) {
                return -1;
            }
            int extLen = (buf[off] & 0xF) + 2;
            if (extLen > len) {
                return -1;
            }
            return extLen;
        }

        @Override
        public HeaderExtension next() {
            int extLen = this.getExtLength(RawPacket.this.buffer, this.nextOff, this.remainingLen);
            if (extLen <= 0) {
                throw new IllegalStateException("Invalid extension length. Did hasNext() return true?");
            }
            this.headerExtension.setOffsetLength(this.nextOff, extLen);
            this.nextOff += extLen;
            this.remainingLen -= extLen;
            return this.headerExtension;
        }
    }

    public class HeaderExtension
    extends ByteArrayBufferImpl {
        HeaderExtension() {
            super(RawPacket.this.buffer, 0, 0);
        }

        public int getExtId() {
            if (super.getLength() <= 0) {
                return -1;
            }
            return (this.buffer[super.getOffset()] & 0xF0) >>> 4;
        }

        public int getExtLength() {
            return (this.buffer[super.getOffset()] & 0xF) + 1;
        }
    }
}

