/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.java.otr4j.OtrEngineHost;
import net.java.otr4j.OtrEngineListener;
import net.java.otr4j.OtrSessionManager;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;
import net.java.otr4j.session.SessionImpl;

public class OtrSessionManagerImpl
implements OtrSessionManager {
    private OtrEngineHost host;
    private Map<SessionID, Session> sessions;
    private final List<OtrEngineListener> listeners = new ArrayList<OtrEngineListener>();

    public OtrSessionManagerImpl(OtrEngineHost host) {
        if (host == null) {
            throw new IllegalArgumentException("OtrEgineHost is required.");
        }
        this.setHost(host);
    }

    @Override
    public Session getSession(SessionID sessionID) {
        if (sessionID == null || sessionID.equals(SessionID.EMPTY)) {
            throw new IllegalArgumentException();
        }
        if (this.sessions == null) {
            this.sessions = new Hashtable<SessionID, Session>();
        }
        if (!this.sessions.containsKey(sessionID)) {
            SessionImpl session = new SessionImpl(sessionID, this.getHost());
            this.sessions.put(sessionID, session);
            session.addOtrEngineListener(new OtrEngineListener(){

                @Override
                public void sessionStatusChanged(SessionID sessionID) {
                    for (OtrEngineListener l : OtrSessionManagerImpl.this.listeners) {
                        l.sessionStatusChanged(sessionID);
                    }
                }

                @Override
                public void multipleInstancesDetected(SessionID sessionID) {
                    for (OtrEngineListener l : OtrSessionManagerImpl.this.listeners) {
                        l.multipleInstancesDetected(sessionID);
                    }
                }

                @Override
                public void outgoingSessionChanged(SessionID sessionID) {
                    for (OtrEngineListener l : OtrSessionManagerImpl.this.listeners) {
                        l.outgoingSessionChanged(sessionID);
                    }
                }
            });
            return session;
        }
        return this.sessions.get(sessionID);
    }

    private void setHost(OtrEngineHost host) {
        this.host = host;
    }

    private OtrEngineHost getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOtrEngineListener(OtrEngineListener l) {
        List<OtrEngineListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

