/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.interfaces.DHPublicKey;
import net.java.otr4j.OtrException;
import net.java.otr4j.crypto.OtrCryptoEngine;
import net.java.otr4j.crypto.OtrCryptoEngineImpl;
import net.java.otr4j.io.SerializationUtils;
import net.java.otr4j.io.messages.AbstractEncodedMessage;
import net.java.otr4j.io.messages.AbstractMessage;
import net.java.otr4j.io.messages.DHCommitMessage;
import net.java.otr4j.io.messages.DHKeyMessage;
import net.java.otr4j.io.messages.QueryMessage;
import net.java.otr4j.io.messages.RevealSignatureMessage;
import net.java.otr4j.io.messages.SignatureM;
import net.java.otr4j.io.messages.SignatureMessage;
import net.java.otr4j.io.messages.SignatureX;
import net.java.otr4j.session.AuthContext;
import net.java.otr4j.session.InstanceTag;
import net.java.otr4j.session.Session;
import net.java.otr4j.session.SessionID;

class AuthContextImpl
extends AuthContext {
    private Session session;
    private int authenticationState;
    private DHPublicKey remoteDHPublicKey;
    private byte[] remoteDHPublicKeyEncrypted;
    private byte[] remoteDHPublicKeyHash;
    private int localDHPrivateKeyID;
    private BigInteger s;
    private byte[] c;
    private byte[] m1;
    private byte[] m2;
    private byte[] cp;
    private byte[] m1p;
    private byte[] m2p;
    private KeyPair localLongTermKeyPair;
    private Boolean isSecure = false;
    private static final Logger logger = Logger.getLogger(AuthContextImpl.class.getName());
    private final AuthContext.MessageFactory messageFactory = new MessageFactoryImpl();
    private PublicKey remoteLongTermPublicKey;

    AuthContextImpl(Session session) {
        this.setSession(session);
        this.reset();
    }

    @Override
    public void reset() {
        logger.finest("Resetting authentication state.");
        this.authenticationState = 0;
        this.r = null;
        this.remoteDHPublicKey = null;
        this.remoteDHPublicKeyEncrypted = null;
        this.remoteDHPublicKeyHash = null;
        this.localDHKeyPair = null;
        this.localDHPrivateKeyID = 1;
        this.localDHPublicKeyBytes = null;
        this.localDHPublicKeyHash = null;
        this.localDHPublicKeyEncrypted = null;
        this.s = null;
        this.c = null;
        this.m1 = null;
        this.m2 = null;
        this.cp = null;
        this.m1p = null;
        this.m2p = null;
        this.localLongTermKeyPair = null;
        this.setIsSecure(false);
    }

    private void setIsSecure(Boolean isSecure) {
        this.isSecure = isSecure;
    }

    @Override
    public boolean getIsSecure() {
        return this.isSecure;
    }

    void setAuthenticationState(int authenticationState) {
        this.authenticationState = authenticationState;
    }

    private int getAuthenticationState() {
        return this.authenticationState;
    }

    private byte[] getR() {
        if (this.r == null) {
            logger.finest("Picking random key r.");
            this.r = new byte[16];
            new Random().nextBytes(this.r);
        }
        return this.r;
    }

    private void setRemoteDHPublicKey(DHPublicKey dhPublicKey) throws OtrException {
        if (dhPublicKey.getY().compareTo(OtrCryptoEngine.MODULUS_MINUS_TWO) > 0) {
            throw new OtrException(new IllegalArgumentException("Illegal D-H Public Key value, Ignoring message."));
        }
        if (dhPublicKey.getY().compareTo(OtrCryptoEngine.BIGINTEGER_TWO) < 0) {
            throw new OtrException(new IllegalArgumentException("Illegal D-H Public Key value, Ignoring message."));
        }
        logger.finest("Received D-H Public Key is a legal value.");
        this.remoteDHPublicKey = dhPublicKey;
    }

    @Override
    public DHPublicKey getRemoteDHPublicKey() {
        return this.remoteDHPublicKey;
    }

    private void setRemoteDHPublicKeyEncrypted(byte[] remoteDHPublicKeyEncrypted) {
        logger.finest("Storing encrypted remote public key.");
        this.remoteDHPublicKeyEncrypted = remoteDHPublicKeyEncrypted;
    }

    private byte[] getRemoteDHPublicKeyEncrypted() {
        return this.remoteDHPublicKeyEncrypted;
    }

    private void setRemoteDHPublicKeyHash(byte[] remoteDHPublicKeyHash) {
        logger.finest("Storing encrypted remote public key hash.");
        this.remoteDHPublicKeyHash = remoteDHPublicKeyHash;
    }

    private byte[] getRemoteDHPublicKeyHash() {
        return this.remoteDHPublicKeyHash;
    }

    @Override
    public KeyPair getLocalDHKeyPair() {
        if (this.localDHKeyPair == null) {
            this.localDHKeyPair = new OtrCryptoEngineImpl().generateDHKeyPair();
            logger.finest("Generated local D-H key pair.");
        }
        return this.localDHKeyPair;
    }

    private int getLocalDHKeyPairID() {
        return this.localDHPrivateKeyID;
    }

    private byte[] getLocalDHPublicKeyHash() throws OtrException {
        if (this.localDHPublicKeyHash == null) {
            this.localDHPublicKeyHash = new OtrCryptoEngineImpl().sha256Hash(this.getLocalDHPublicKeyBytes());
            logger.finest("Hashed local D-H public key.");
        }
        return this.localDHPublicKeyHash;
    }

    private byte[] getLocalDHPublicKeyEncrypted() throws OtrException {
        if (this.localDHPublicKeyEncrypted == null) {
            this.localDHPublicKeyEncrypted = new OtrCryptoEngineImpl().aesEncrypt(this.getR(), null, this.getLocalDHPublicKeyBytes());
            logger.finest("Encrypted our D-H public key.");
        }
        return this.localDHPublicKeyEncrypted;
    }

    @Override
    public BigInteger getS() throws OtrException {
        if (this.s == null) {
            this.s = new OtrCryptoEngineImpl().generateSecret(this.getLocalDHKeyPair().getPrivate(), this.getRemoteDHPublicKey());
            logger.finest("Generated shared secret.");
        }
        return this.s;
    }

    private byte[] getC() throws OtrException {
        if (this.c != null) {
            return this.c;
        }
        byte[] h2 = this.h2((byte)1);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        this.c = new byte[16];
        buff.get(this.c);
        logger.finest("Computed c.");
        return this.c;
    }

    private byte[] getM1() throws OtrException {
        if (this.m1 != null) {
            return this.m1;
        }
        byte[] h2 = this.h2((byte)2);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] tmpM1 = new byte[32];
        buff.get(tmpM1);
        logger.finest("Computed m1.");
        this.m1 = tmpM1;
        return tmpM1;
    }

    private byte[] getM2() throws OtrException {
        if (this.m2 != null) {
            return this.m2;
        }
        byte[] h2 = this.h2((byte)3);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] tmpM2 = new byte[32];
        buff.get(tmpM2);
        logger.finest("Computed m2.");
        this.m2 = tmpM2;
        return tmpM2;
    }

    private byte[] getCp() throws OtrException {
        if (this.cp != null) {
            return this.cp;
        }
        byte[] h2 = this.h2((byte)1);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] tmpCp = new byte[16];
        buff.position(16);
        buff.get(tmpCp);
        logger.finest("Computed c'.");
        this.cp = tmpCp;
        return tmpCp;
    }

    private byte[] getM1p() throws OtrException {
        if (this.m1p != null) {
            return this.m1p;
        }
        byte[] h2 = this.h2((byte)4);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] tmpM1p = new byte[32];
        buff.get(tmpM1p);
        this.m1p = tmpM1p;
        logger.finest("Computed m1'.");
        return tmpM1p;
    }

    private byte[] getM2p() throws OtrException {
        if (this.m2p != null) {
            return this.m2p;
        }
        byte[] h2 = this.h2((byte)5);
        ByteBuffer buff = ByteBuffer.wrap(h2);
        byte[] tmpM2p = new byte[32];
        buff.get(tmpM2p);
        this.m2p = tmpM2p;
        logger.finest("Computed m2'.");
        return tmpM2p;
    }

    @Override
    public KeyPair getLocalLongTermKeyPair() throws OtrException {
        if (this.localLongTermKeyPair == null) {
            this.localLongTermKeyPair = this.getSession().getLocalKeyPair();
        }
        return this.localLongTermKeyPair;
    }

    private byte[] h2(byte b) throws OtrException {
        byte[] secbytes;
        try {
            secbytes = SerializationUtils.writeMpi(this.getS());
        }
        catch (IOException e) {
            throw new OtrException(e);
        }
        int len = secbytes.length + 1;
        ByteBuffer buff = ByteBuffer.allocate(len);
        buff.put(b);
        buff.put(secbytes);
        byte[] sdata = buff.array();
        return new OtrCryptoEngineImpl().sha256Hash(sdata);
    }

    private byte[] getLocalDHPublicKeyBytes() throws OtrException {
        if (this.localDHPublicKeyBytes == null) {
            try {
                this.localDHPublicKeyBytes = SerializationUtils.writeMpi(((DHPublicKey)this.getLocalDHKeyPair().getPublic()).getY());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }
        return this.localDHPublicKeyBytes;
    }

    @Override
    public void handleReceivingMessage(AbstractMessage m) throws OtrException {
        if (m instanceof AbstractEncodedMessage && this.validateMessage((AbstractEncodedMessage)m)) {
            switch (m.messageType) {
                case 2: {
                    this.handleDHCommitMessage((DHCommitMessage)m);
                    break;
                }
                case 10: {
                    this.handleDHKeyMessage((DHKeyMessage)m);
                    break;
                }
                case 17: {
                    this.handleRevealSignatureMessage((RevealSignatureMessage)m);
                    break;
                }
                case 18: {
                    this.handleSignatureMessage((SignatureMessage)m);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private static String extractMessageTypeName(AbstractMessage msg) {
        return msg.getClass().getSimpleName().replaceFirst("Message$", "");
    }

    private boolean validateMessage(AbstractEncodedMessage m) throws OtrException {
        String messageTypeName = AuthContextImpl.extractMessageTypeName(m);
        Session mySession = this.getSession();
        SessionID sessionID = mySession.getSessionID();
        logger.log(Level.FINEST, "{0} received a {1} message from {2} through {3}.", new Object[]{sessionID.getAccountID(), messageTypeName, sessionID.getUserID(), sessionID.getProtocolName()});
        if (m.protocolVersion == 2 && !mySession.getSessionPolicy().getAllowV2()) {
            logger.finest("ALLOW_V2 is not set, ignore this message.");
            return false;
        }
        if (m.protocolVersion == 3 && !mySession.getSessionPolicy().getAllowV3()) {
            logger.finest("ALLOW_V3 is not set, ignore this message.");
            return false;
        }
        if (m.protocolVersion == 3 && mySession.getSenderInstanceTag().getValue() != m.receiverInstanceTag && (m.messageType != 2 || m.receiverInstanceTag != 0)) {
            logger.log(Level.FINEST, "Received a {0} Message with receiver instance tag that is different from ours, ignore this message", messageTypeName);
            return false;
        }
        return true;
    }

    private void handleSignatureMessage(SignatureMessage m) throws OtrException {
        switch (this.getAuthenticationState()) {
            case 3: {
                byte[] signature;
                SignatureX remoteX;
                if (!m.verify(this.getM2p())) {
                    logger.finest("Signature MACs are not equal, ignoring message.");
                    return;
                }
                byte[] remoteXDecrypted = m.decrypt(this.getCp());
                try {
                    remoteX = SerializationUtils.toMysteriousX(remoteXDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                PublicKey localRemoteLongTermPublicKey = remoteX.longTermPublicKey;
                SignatureM remoteM = new SignatureM(this.getRemoteDHPublicKey(), (DHPublicKey)this.getLocalDHKeyPair().getPublic(), localRemoteLongTermPublicKey, remoteX.dhKeyID);
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                try {
                    signature = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(remoteM), this.getM1p());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                if (!otrCryptoEngine.verify(signature, localRemoteLongTermPublicKey, remoteX.signature)) {
                    logger.finest("Signature verification failed.");
                    return;
                }
                this.setIsSecure(true);
                this.setRemoteLongTermPublicKey(localRemoteLongTermPublicKey);
                break;
            }
            default: {
                logger.finest("We were not expecting a signature, ignoring message.");
            }
        }
    }

    private void handleRevealSignatureMessage(RevealSignatureMessage m) throws OtrException {
        switch (this.getAuthenticationState()) {
            case 2: {
                byte[] signature;
                SignatureX remoteX;
                BigInteger remoteDHPublicKeyMpi;
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] remoteDHPublicKeyDecrypted = otrCryptoEngine.aesDecrypt(m.revealedKey, null, this.getRemoteDHPublicKeyEncrypted());
                byte[] remoteDHPublicKeyHash = otrCryptoEngine.sha256Hash(remoteDHPublicKeyDecrypted);
                if (!Arrays.equals(remoteDHPublicKeyHash, this.getRemoteDHPublicKeyHash())) {
                    logger.finest("Hashes don't match, ignoring message.");
                    return;
                }
                try {
                    remoteDHPublicKeyMpi = SerializationUtils.readMpi(remoteDHPublicKeyDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                this.setRemoteDHPublicKey(otrCryptoEngine.getDHPublicKey(remoteDHPublicKeyMpi));
                if (!m.verify(this.getM2())) {
                    logger.finest("Signature MACs are not equal, ignoring message.");
                    return;
                }
                byte[] remoteXDecrypted = m.decrypt(this.getC());
                try {
                    remoteX = SerializationUtils.toMysteriousX(remoteXDecrypted);
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                PublicKey remoteLongTermPublicKey = remoteX.longTermPublicKey;
                SignatureM remoteM = new SignatureM(this.getRemoteDHPublicKey(), (DHPublicKey)this.getLocalDHKeyPair().getPublic(), remoteLongTermPublicKey, remoteX.dhKeyID);
                try {
                    signature = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(remoteM), this.getM1());
                }
                catch (IOException e) {
                    throw new OtrException(e);
                }
                if (!otrCryptoEngine.verify(signature, remoteLongTermPublicKey, remoteX.signature)) {
                    logger.finest("Signature verification failed.");
                    return;
                }
                logger.finest("Signature verification succeeded.");
                this.setAuthenticationState(0);
                this.setIsSecure(true);
                this.setRemoteLongTermPublicKey(remoteLongTermPublicKey);
                this.getSession().injectMessage(this.messageFactory.getSignatureMessage());
                break;
            }
            default: {
                logger.finest("Ignoring message.");
            }
        }
    }

    private void handleDHKeyMessage(DHKeyMessage m) throws OtrException {
        this.getSession().setReceiverInstanceTag(new InstanceTag(m.senderInstanceTag));
        switch (this.getAuthenticationState()) {
            case 0: 
            case 1: {
                this.setRemoteDHPublicKey(m.dhPublicKey);
                this.setAuthenticationState(3);
                this.getSession().injectMessage(this.messageFactory.getRevealSignatureMessage());
                logger.finest("Sent Reveal Signature.");
                break;
            }
            case 3: {
                if (m.dhPublicKey.getY().equals(this.getRemoteDHPublicKey().getY())) {
                    this.getSession().injectMessage(this.messageFactory.getRevealSignatureMessage());
                    logger.finest("Resent Reveal Signature.");
                    break;
                }
                logger.finest("Ignoring message.");
                break;
            }
        }
    }

    private void handleDHCommitMessage(DHCommitMessage m) throws OtrException {
        this.getSession().setReceiverInstanceTag(new InstanceTag(m.senderInstanceTag));
        switch (this.getAuthenticationState()) {
            case 0: {
                this.reset();
                this.getSession().setProtocolVersion(m.protocolVersion);
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Sent D-H key.");
                break;
            }
            case 1: {
                BigInteger ourHash = new BigInteger(1, this.getLocalDHPublicKeyHash());
                BigInteger theirHash = new BigInteger(1, m.dhPublicKeyHash);
                if (theirHash.compareTo(ourHash) == -1) {
                    this.getSession().injectMessage(this.messageFactory.getDHCommitMessage());
                    logger.finest("Ignored the incoming D-H Commit message, but resent our D-H Commit message.");
                    break;
                }
                this.reset();
                this.getSession().setProtocolVersion(m.protocolVersion);
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Forgot our old gx value that we sent (encrypted) earlier, and pretended we're in AUTHSTATE_NONE -> Sent D-H key.");
                break;
            }
            case 2: {
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Sent D-H key.");
                break;
            }
            case 3: {
                this.reset();
                this.setRemoteDHPublicKeyEncrypted(m.dhPublicKeyEncrypted);
                this.setRemoteDHPublicKeyHash(m.dhPublicKeyHash);
                this.setAuthenticationState(2);
                this.getSession().injectMessage(this.messageFactory.getDHKeyMessage());
                logger.finest("Sent D-H key.");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can not handle message in auth. state " + this.getAuthenticationState());
            }
        }
    }

    @Override
    public void startAuth() throws OtrException {
        logger.finest("Starting Authenticated Key Exchange, sending query message");
        this.getSession().injectMessage(this.messageFactory.getQueryMessage());
    }

    @Override
    public DHCommitMessage respondAuth(Integer version) throws OtrException {
        if (version != 2 && version != 3) {
            throw new OtrException(new Exception("Only allowed versions are: 2, 3"));
        }
        logger.finest("Responding to Query Message");
        this.reset();
        this.getSession().setProtocolVersion(version);
        this.setAuthenticationState(1);
        logger.finest("Generating D-H Commit.");
        DHCommitMessage message = this.messageFactory.getDHCommitMessage();
        return message;
    }

    private void setSession(Session session) {
        this.session = session;
    }

    private Session getSession() {
        return this.session;
    }

    @Override
    public PublicKey getRemoteLongTermPublicKey() {
        return this.remoteLongTermPublicKey;
    }

    private void setRemoteLongTermPublicKey(PublicKey pubKey) {
        this.remoteLongTermPublicKey = pubKey;
    }

    class MessageFactoryImpl
    extends AuthContext.MessageFactory {
        MessageFactoryImpl() {
        }

        @Override
        QueryMessage getQueryMessage() {
            List<Integer> versions = Arrays.asList(2, 3);
            return new QueryMessage(versions);
        }

        @Override
        DHCommitMessage getDHCommitMessage() throws OtrException {
            DHCommitMessage message = new DHCommitMessage(AuthContextImpl.this.getSession().getProtocolVersion(), AuthContextImpl.this.getLocalDHPublicKeyHash(), AuthContextImpl.this.getLocalDHPublicKeyEncrypted());
            message.senderInstanceTag = AuthContextImpl.this.session.getSenderInstanceTag().getValue();
            message.receiverInstanceTag = 0;
            return message;
        }

        @Override
        DHKeyMessage getDHKeyMessage() {
            DHKeyMessage dhKeyMessage = new DHKeyMessage(AuthContextImpl.this.getSession().getProtocolVersion(), (DHPublicKey)AuthContextImpl.this.getLocalDHKeyPair().getPublic());
            dhKeyMessage.senderInstanceTag = AuthContextImpl.this.getSession().getSenderInstanceTag().getValue();
            dhKeyMessage.receiverInstanceTag = AuthContextImpl.this.getSession().getReceiverInstanceTag().getValue();
            return dhKeyMessage;
        }

        @Override
        RevealSignatureMessage getRevealSignatureMessage() throws OtrException {
            try {
                SignatureM m = new SignatureM((DHPublicKey)AuthContextImpl.this.getLocalDHKeyPair().getPublic(), AuthContextImpl.this.getRemoteDHPublicKey(), AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID());
                OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
                byte[] mhash = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(m), AuthContextImpl.this.getM1());
                byte[] signature = otrCryptoEngine.sign(mhash, AuthContextImpl.this.getLocalLongTermKeyPair().getPrivate());
                SignatureX mysteriousX = new SignatureX(AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID(), signature);
                byte[] xEncrypted = otrCryptoEngine.aesEncrypt(AuthContextImpl.this.getC(), null, SerializationUtils.toByteArray(mysteriousX));
                byte[] tmp = SerializationUtils.writeData(xEncrypted);
                byte[] xEncryptedHash = otrCryptoEngine.sha256Hmac160(tmp, AuthContextImpl.this.getM2());
                RevealSignatureMessage revealSignatureMessage = new RevealSignatureMessage(AuthContextImpl.this.getSession().getProtocolVersion(), xEncrypted, xEncryptedHash, AuthContextImpl.this.getR());
                revealSignatureMessage.senderInstanceTag = AuthContextImpl.this.getSession().getSenderInstanceTag().getValue();
                revealSignatureMessage.receiverInstanceTag = AuthContextImpl.this.getSession().getReceiverInstanceTag().getValue();
                return revealSignatureMessage;
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }

        @Override
        SignatureMessage getSignatureMessage() throws OtrException {
            byte[] mhash;
            SignatureM m = new SignatureM((DHPublicKey)AuthContextImpl.this.getLocalDHKeyPair().getPublic(), AuthContextImpl.this.getRemoteDHPublicKey(), AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID());
            OtrCryptoEngineImpl otrCryptoEngine = new OtrCryptoEngineImpl();
            try {
                mhash = otrCryptoEngine.sha256Hmac(SerializationUtils.toByteArray(m), AuthContextImpl.this.getM1p());
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
            byte[] signature = otrCryptoEngine.sign(mhash, AuthContextImpl.this.getLocalLongTermKeyPair().getPrivate());
            SignatureX mysteriousX = new SignatureX(AuthContextImpl.this.getLocalLongTermKeyPair().getPublic(), AuthContextImpl.this.getLocalDHKeyPairID(), signature);
            try {
                byte[] xEncrypted = otrCryptoEngine.aesEncrypt(AuthContextImpl.this.getCp(), null, SerializationUtils.toByteArray(mysteriousX));
                byte[] tmp = SerializationUtils.writeData(xEncrypted);
                byte[] xEncryptedHash = otrCryptoEngine.sha256Hmac160(tmp, AuthContextImpl.this.getM2p());
                SignatureMessage signatureMessage = new SignatureMessage(AuthContextImpl.this.getSession().getProtocolVersion(), xEncrypted, xEncryptedHash);
                signatureMessage.senderInstanceTag = AuthContextImpl.this.getSession().getSenderInstanceTag().getValue();
                signatureMessage.receiverInstanceTag = AuthContextImpl.this.getSession().getReceiverInstanceTag().getValue();
                return signatureMessage;
            }
            catch (IOException e) {
                throw new OtrException(e);
            }
        }
    }
}

