/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.util.Random;

public class InstanceTag {
    private static final Random RANDOM = new Random();
    public static final int ZERO_VALUE = 0;
    public static final int SMALLEST_VALUE = 256;
    public static final int HIGHEST_VALUE = -1;
    public static final InstanceTag ZERO_TAG = new InstanceTag(0);
    public static final InstanceTag SMALLEST_TAG = new InstanceTag(256);
    public static final InstanceTag HIGHEST_TAG = new InstanceTag(-1);
    private static final long RANGE = 0xFFFFFEFFL;
    private final int value;

    public static boolean isValidInstanceTag(int tagValue) {
        return 0 >= tagValue || tagValue >= 256;
    }

    public InstanceTag() {
        long val = (long)(RANDOM.nextDouble() * 4.294967039E9) + 256L;
        this.value = (int)val;
    }

    public int getValue() {
        return this.value;
    }

    InstanceTag(int value) {
        if (!InstanceTag.isValidInstanceTag(value)) {
            throw new IllegalArgumentException("Invalid tag value.");
        }
        this.value = value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InstanceTag)) {
            return false;
        }
        InstanceTag otherInstanceTag = (InstanceTag)other;
        return this.value == otherInstanceTag.getValue();
    }

    public int hashCode() {
        return this.value;
    }
}

