/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SelectableMap<K, V>
implements Map<K, V> {
    private final Map<K, V> base;
    private volatile boolean selected;
    private volatile K selection;

    public SelectableMap(Map<K, V> base) {
        if (base == null) {
            throw new NullPointerException("base");
        }
        this.base = base;
        this.selection = null;
        this.selected = false;
    }

    public SelectableMap(Map<K, V> base, K selected) {
        this(base);
        this.select(selected);
    }

    @Override
    public int size() {
        return this.base.size();
    }

    @Override
    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.base.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.base.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.base.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.base.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.isSelected() && this.selection.equals(key)) {
            this.deselect();
        }
        return this.base.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.base.putAll(m);
    }

    @Override
    public void clear() {
        this.deselect();
        this.base.clear();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.base.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.base.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.base.entrySet());
    }

    public final boolean isSelected() {
        return this.selected;
    }

    public final V getSelected() {
        if (!this.selected) {
            throw new IllegalStateException("no selection available");
        }
        return this.base.get(this.selection);
    }

    public final void select(K key) {
        if (!this.base.containsKey(key)) {
            throw new IllegalArgumentException("key is not in base map");
        }
        this.selection = key;
        this.selected = true;
    }

    public final void deselect() {
        this.selected = false;
    }
}

