/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.spring.web;

import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.jiucai.appframework.base.domain.PageInfo;
import org.jiucai.appframework.base.util.CommonUtil;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    protected Logs log = LogUtil.getLog(this.getClass());
    protected static final String SUCCESS = "1";
    protected static final String FAILED = "0";
    protected static final String CHARSET = "UTF-8";
    public static final String REQ_KEY_PAGE = "p";

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setLenient(false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)dateFormat, false));
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    public PageInfo getPageInfo(Long resultSize, HttpServletRequest request) {
        String pageNo = request.getParameter(REQ_KEY_PAGE);
        Long pNo = 1L;
        if (null != pageNo) {
            try {
                pNo = Long.parseLong(pageNo);
            }
            catch (NumberFormatException e) {
                this.log.error("Error pageNo value, goto first page: " + e.getMessage());
            }
        }
        Long pageSize = CommonUtil.getPageSize();
        Long pageCount = CommonUtil.getPageCount(resultSize, pageSize);
        PageInfo page = new PageInfo();
        page.setPageNo(pNo);
        page.setResultSize(resultSize);
        page.setPageCount(pageCount);
        page.setPageSize(pageSize);
        return page;
    }
}

