/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUtil {
    protected static Log log = LogFactory.getLog(ConfigUtil.class);
    protected static CompositeConfiguration config;
    private static String FILE_ENCODING;
    private static String SUFFIX_PERPERTIES;
    private static Map<String, Configuration> cfgMap;

    private static synchronized void init() {
        try {
            config = new CompositeConfiguration();
            config.setLogger(log);
            SystemConfiguration configSys = new SystemConfiguration();
            cfgMap = new HashMap<String, Configuration>();
            cfgMap.put("system", (Configuration)configSys);
            config.addConfiguration((Configuration)configSys);
            log.debug((Object)"loading System Properties");
        }
        catch (Exception e) {
            log.error((Object)("load config file failed: " + ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
    }

    public static synchronized Configuration getConfiguration() {
        if (null == config) {
            ConfigUtil.init();
        }
        return config;
    }

    public static synchronized String setEncoding(String encoding) {
        FILE_ENCODING = encoding;
        return FILE_ENCODING;
    }

    public static synchronized String setSuffix(String suffix) {
        SUFFIX_PERPERTIES = suffix;
        return SUFFIX_PERPERTIES;
    }

    public static synchronized Configuration addConfig(String configFileName) {
        try {
            if (configFileName.toLowerCase().lastIndexOf(SUFFIX_PERPERTIES) == -1) {
                configFileName = configFileName + SUFFIX_PERPERTIES;
            }
            if (null != cfgMap.get(configFileName)) {
                config.removeConfiguration(cfgMap.get(configFileName));
                cfgMap.remove(configFileName);
                log.debug((Object)("removing config: " + configFileName));
            }
            PropertiesConfiguration configApp = new PropertiesConfiguration();
            configApp.setEncoding(FILE_ENCODING);
            configApp.load(configFileName);
            configApp.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            log.debug((Object)("adding config file: " + configFileName));
            cfgMap.put(configFileName, (Configuration)configApp);
            config.addConfiguration((Configuration)configApp);
            log.debug((Object)("Config item count: " + cfgMap.size()));
        }
        catch (ConfigurationException e) {
            log.error((Object)("load config file failed: " + ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
        return config;
    }

    public static synchronized String getString(String key) {
        String value = null;
        try {
            value = config.getString(key);
            if (null == value) {
                log.warn((Object)("config value of " + key + " is null. "));
            }
        }
        catch (Exception e) {
            log.error((Object)("can not find config key[" + key + "]. "));
            log.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return value;
    }

    public static void main(String[] args) {
        String key = "mail.from_name";
        ConfigUtil.addConfig("mail");
        String s = ConfigUtil.getString(key);
        System.out.println("s = " + s);
    }

    static {
        FILE_ENCODING = "UTF-8";
        SUFFIX_PERPERTIES = ".properties";
        ConfigUtil.init();
    }
}

