/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jiucai.appframework.base.domain.KeyValuePair;
import org.jiucai.appframework.common.util.BaseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvDownloadUtil
extends BaseUtil {
    static String fileCharset = "GBK";

    public static final String saveFile(String filePath, String fileName, List<KeyValuePair> headList, List<Map<String, Object>> dataList, List<Map<String, Object>> sumList, Boolean isAppend) {
        if (StringUtils.isEmpty((String)filePath)) {
            filePath = "/tmp/report";
            log.info("use default download path:  " + filePath);
        }
        if (!filePath.endsWith("/")) {
            filePath = filePath + "/";
        }
        if (!fileName.endsWith(".csv")) {
            fileName = fileName + ".csv";
        }
        String createFilePath = filePath;
        filePath = filePath + fileName;
        try {
            String[] endDa;
            List<List<String>> datas;
            Object[] data;
            File file = new File(createFilePath);
            if (!file.isDirectory()) {
                file.mkdirs();
            }
            FileOutputStream out = new FileOutputStream(filePath, (boolean)isAppend);
            CsvWriter wr = new CsvWriter(out, ',', Charset.forName(fileCharset));
            wr.setForceQualifier(true);
            if (CollectionUtils.isNotEmpty(headList) && !isAppend.booleanValue()) {
                ArrayList<String> headNamesList = new ArrayList<String>();
                for (KeyValuePair kvp : headList) {
                    headNamesList.add(CsvDownloadUtil.convertMapValue(kvp.getText()));
                }
                for (int i = 0; i < headNamesList.size(); ++i) {
                    headNamesList.set(i, (String)headNamesList.get(i));
                }
                data = headNamesList.toArray(new String[headNamesList.size()]);
                wr.writeRecord((String[])data);
            }
            if (CollectionUtils.isNotEmpty(sumList) && !isAppend.booleanValue()) {
                datas = CsvDownloadUtil.accountDataBody(headList, sumList);
                data = datas.toArray(new ArrayList[datas.size()]);
                for (List list : data) {
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, CsvDownloadUtil.convertMapValue(list.get(i)));
                    }
                    endDa = list.toArray(new String[list.size()]);
                    wr.writeRecord(endDa);
                }
            }
            if (CollectionUtils.isNotEmpty(dataList)) {
                datas = CsvDownloadUtil.accountDataBody(headList, dataList);
                data = datas.toArray(new ArrayList[datas.size()]);
                for (List list : data) {
                    for (int i = 0; i < list.size(); ++i) {
                        list.set(i, CsvDownloadUtil.convertMapValue(list.get(i)));
                    }
                    endDa = list.toArray(new String[list.size()]);
                    wr.writeRecord(endDa);
                }
            }
            wr.close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            log.info("\u6587\u4ef6\u4e0d\u5b58\u5728:" + filePath + e.getMessage());
        }
        catch (IOException e) {
            log.info("\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38:" + e.getMessage());
        }
        return filePath;
    }

    public static String getFileName(String displayName) {
        String displayFileName = displayName;
        SimpleDateFormat df = new SimpleDateFormat("MMddHHmmss");
        String dateStr = df.format(new Date());
        if (!(displayFileName = displayFileName + "_" + dateStr).endsWith(".csv")) {
            displayFileName = displayFileName + ".csv";
        }
        return displayFileName;
    }

    private static List<List<String>> accountDataBody(List<KeyValuePair> headList, List<Map<String, Object>> dataList) {
        ArrayList<List<String>> dataBody = new ArrayList<List<String>>();
        ArrayList<String> data = null;
        ArrayList<String> headCode = new ArrayList<String>();
        if (null != headList) {
            for (KeyValuePair keyValuePair : headList) {
                headCode.add(keyValuePair.getCode().toLowerCase());
            }
        }
        for (Map map : dataList) {
            data = new ArrayList<String>();
            for (String code : headCode) {
                data.add(String.valueOf(map.get(code)));
            }
            dataBody.add(data);
        }
        return dataBody;
    }
}

