/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.common.util.BaseUtil;

public class LocalIPUtil
extends BaseUtil {
    public static void main(String[] args) {
        String serverIP = LocalIPUtil.getLocalIP();
        System.out.println("LocalIP : " + serverIP);
    }

    public static boolean isWindowsOS() {
        boolean isWindowsOS = false;
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().indexOf("windows") > -1) {
            isWindowsOS = true;
        }
        return isWindowsOS;
    }

    public static String getLocalIP() {
        String sIP = "";
        InetAddress ip = null;
        try {
            if (LocalIPUtil.isWindowsOS()) {
                ip = InetAddress.getLocalHost();
            } else {
                boolean bFindIP = false;
                Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
                block2: while (netInterfaces.hasMoreElements() && !bFindIP) {
                    NetworkInterface ni = netInterfaces.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        ip = ips.nextElement();
                        if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                        bFindIP = true;
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u672c\u673aIP\u5931\u8d25: " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        if (null != ip) {
            sIP = ip.getHostAddress();
        }
        return sIP;
    }
}

