/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.encode;

public class MD5 {
    static final int S11 = 7;
    static final int S12 = 12;
    static final int S13 = 17;
    static final int S14 = 22;
    static final int S21 = 5;
    static final int S22 = 9;
    static final int S23 = 14;
    static final int S24 = 20;
    static final int S31 = 4;
    static final int S32 = 11;
    static final int S33 = 16;
    static final int S34 = 23;
    static final int S41 = 6;
    static final int S42 = 10;
    static final int S43 = 15;
    static final int S44 = 21;
    static final byte[] PADDING = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static long[] state = new long[4];
    private static long[] count = new long[2];
    private static byte[] buffer = new byte[64];
    private static String digestResult;
    private static byte[] digest;

    public static String encode(String inbuf) {
        MD5.md5Init();
        MD5.md5Update(inbuf.getBytes(), inbuf.length());
        MD5.md5Final();
        digestResult = "";
        for (int i = 0; i < 16; ++i) {
            digestResult = digestResult + MD5.byte2Hex(digest[i]);
        }
        if (null != digestResult) {
            digestResult = digestResult.toLowerCase();
        }
        return digestResult;
    }

    public MD5() {
        MD5.md5Init();
    }

    private static void md5Init() {
        MD5.count[0] = 0L;
        MD5.count[1] = 0L;
        MD5.state[0] = 1732584193L;
        MD5.state[1] = 4023233417L;
        MD5.state[2] = 2562383102L;
        MD5.state[3] = 271733878L;
    }

    private static long F(long x, long y, long z) {
        return x & y | (x ^ 0xFFFFFFFFFFFFFFFFL) & z;
    }

    private static long G(long x, long y, long z) {
        return x & z | y & (z ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long H(long x, long y, long z) {
        return x ^ y ^ z;
    }

    private static long I(long x, long y, long z) {
        return y ^ (x | z ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private static long FF(long a, long b, long c, long d, long x, long s, long ac) {
        a += MD5.F(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    private static long GG(long a, long b, long c, long d, long x, long s, long ac) {
        a += MD5.G(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    private static long HH(long a, long b, long c, long d, long x, long s, long ac) {
        a += MD5.H(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    private static long II(long a, long b, long c, long d, long x, long s, long ac) {
        a += MD5.I(b, c, d) + x + ac;
        a = (int)a << (int)s | (int)a >>> (int)(32L - s);
        return a += b;
    }

    private static void md5Update(byte[] inbuf, int inputLen) {
        int i;
        byte[] block = new byte[64];
        int index = (int)(count[0] >>> 3) & 0x3F;
        count[0] = count[0] + (long)(inputLen << 3);
        if (count[0] < (long)(inputLen << 3)) {
            count[1] = count[1] + 1L;
        }
        count[1] = count[1] + (long)(inputLen >>> 29);
        int partLen = 64 - index;
        if (inputLen >= partLen) {
            MD5.md5Memcpy(buffer, inbuf, index, 0, partLen);
            MD5.md5Transform(buffer);
            i = partLen;
            while (i + 63 < inputLen) {
                MD5.md5Memcpy(block, inbuf, 0, i, 64);
                MD5.md5Transform(block);
                i += 64;
            }
            index = 0;
        } else {
            i = 0;
        }
        MD5.md5Memcpy(buffer, inbuf, index, i, inputLen - i);
    }

    private static void md5Final() {
        byte[] bits = new byte[8];
        MD5.encode(bits, count, 8);
        int index = (int)(count[0] >>> 3) & 0x3F;
        int padLen = index < 56 ? 56 - index : 120 - index;
        MD5.md5Update(PADDING, padLen);
        MD5.md5Update(bits, 8);
        MD5.encode(digest, state, 16);
    }

    private static void md5Memcpy(byte[] output, byte[] input, int outpos, int inpos, int len) {
        for (int i = 0; i < len; ++i) {
            output[outpos + i] = input[inpos + i];
        }
    }

    private static void md5Transform(byte[] block) {
        long a = state[0];
        long b = state[1];
        long c = state[2];
        long d = state[3];
        long[] x = new long[16];
        MD5.decode(x, block, 64);
        a = MD5.FF(a, b, c, d, x[0], 7L, 3614090360L);
        d = MD5.FF(d, a, b, c, x[1], 12L, 3905402710L);
        c = MD5.FF(c, d, a, b, x[2], 17L, 606105819L);
        b = MD5.FF(b, c, d, a, x[3], 22L, 3250441966L);
        a = MD5.FF(a, b, c, d, x[4], 7L, 4118548399L);
        d = MD5.FF(d, a, b, c, x[5], 12L, 1200080426L);
        c = MD5.FF(c, d, a, b, x[6], 17L, 2821735955L);
        b = MD5.FF(b, c, d, a, x[7], 22L, 4249261313L);
        a = MD5.FF(a, b, c, d, x[8], 7L, 1770035416L);
        d = MD5.FF(d, a, b, c, x[9], 12L, 2336552879L);
        c = MD5.FF(c, d, a, b, x[10], 17L, 4294925233L);
        b = MD5.FF(b, c, d, a, x[11], 22L, 2304563134L);
        a = MD5.FF(a, b, c, d, x[12], 7L, 1804603682L);
        d = MD5.FF(d, a, b, c, x[13], 12L, 4254626195L);
        c = MD5.FF(c, d, a, b, x[14], 17L, 2792965006L);
        b = MD5.FF(b, c, d, a, x[15], 22L, 1236535329L);
        a = MD5.GG(a, b, c, d, x[1], 5L, 4129170786L);
        d = MD5.GG(d, a, b, c, x[6], 9L, 3225465664L);
        c = MD5.GG(c, d, a, b, x[11], 14L, 643717713L);
        b = MD5.GG(b, c, d, a, x[0], 20L, 3921069994L);
        a = MD5.GG(a, b, c, d, x[5], 5L, 3593408605L);
        d = MD5.GG(d, a, b, c, x[10], 9L, 38016083L);
        c = MD5.GG(c, d, a, b, x[15], 14L, 3634488961L);
        b = MD5.GG(b, c, d, a, x[4], 20L, 3889429448L);
        a = MD5.GG(a, b, c, d, x[9], 5L, 568446438L);
        d = MD5.GG(d, a, b, c, x[14], 9L, 3275163606L);
        c = MD5.GG(c, d, a, b, x[3], 14L, 4107603335L);
        b = MD5.GG(b, c, d, a, x[8], 20L, 1163531501L);
        a = MD5.GG(a, b, c, d, x[13], 5L, 2850285829L);
        d = MD5.GG(d, a, b, c, x[2], 9L, 4243563512L);
        c = MD5.GG(c, d, a, b, x[7], 14L, 1735328473L);
        b = MD5.GG(b, c, d, a, x[12], 20L, 2368359562L);
        a = MD5.HH(a, b, c, d, x[5], 4L, 4294588738L);
        d = MD5.HH(d, a, b, c, x[8], 11L, 2272392833L);
        c = MD5.HH(c, d, a, b, x[11], 16L, 1839030562L);
        b = MD5.HH(b, c, d, a, x[14], 23L, 4259657740L);
        a = MD5.HH(a, b, c, d, x[1], 4L, 2763975236L);
        d = MD5.HH(d, a, b, c, x[4], 11L, 1272893353L);
        c = MD5.HH(c, d, a, b, x[7], 16L, 4139469664L);
        b = MD5.HH(b, c, d, a, x[10], 23L, 3200236656L);
        a = MD5.HH(a, b, c, d, x[13], 4L, 681279174L);
        d = MD5.HH(d, a, b, c, x[0], 11L, 3936430074L);
        c = MD5.HH(c, d, a, b, x[3], 16L, 3572445317L);
        b = MD5.HH(b, c, d, a, x[6], 23L, 76029189L);
        a = MD5.HH(a, b, c, d, x[9], 4L, 3654602809L);
        d = MD5.HH(d, a, b, c, x[12], 11L, 3873151461L);
        c = MD5.HH(c, d, a, b, x[15], 16L, 530742520L);
        b = MD5.HH(b, c, d, a, x[2], 23L, 3299628645L);
        a = MD5.II(a, b, c, d, x[0], 6L, 4096336452L);
        d = MD5.II(d, a, b, c, x[7], 10L, 1126891415L);
        c = MD5.II(c, d, a, b, x[14], 15L, 2878612391L);
        b = MD5.II(b, c, d, a, x[5], 21L, 4237533241L);
        a = MD5.II(a, b, c, d, x[12], 6L, 1700485571L);
        d = MD5.II(d, a, b, c, x[3], 10L, 2399980690L);
        c = MD5.II(c, d, a, b, x[10], 15L, 4293915773L);
        b = MD5.II(b, c, d, a, x[1], 21L, 2240044497L);
        a = MD5.II(a, b, c, d, x[8], 6L, 1873313359L);
        d = MD5.II(d, a, b, c, x[15], 10L, 4264355552L);
        c = MD5.II(c, d, a, b, x[6], 15L, 2734768916L);
        b = MD5.II(b, c, d, a, x[13], 21L, 1309151649L);
        a = MD5.II(a, b, c, d, x[4], 6L, 4149444226L);
        d = MD5.II(d, a, b, c, x[11], 10L, 3174756917L);
        c = MD5.II(c, d, a, b, x[2], 15L, 718787259L);
        b = MD5.II(b, c, d, a, x[9], 21L, 3951481745L);
        state[0] = state[0] + a;
        state[1] = state[1] + b;
        state[2] = state[2] + c;
        state[3] = state[3] + d;
    }

    private static void encode(byte[] output, long[] input, int len) {
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            output[j] = (byte)(input[i] & 0xFFL);
            output[j + 1] = (byte)(input[i] >>> 8 & 0xFFL);
            output[j + 2] = (byte)(input[i] >>> 16 & 0xFFL);
            output[j + 3] = (byte)(input[i] >>> 24 & 0xFFL);
            ++i;
        }
    }

    private static void decode(long[] output, byte[] input, int len) {
        int i = 0;
        for (int j = 0; j < len; j += 4) {
            output[i] = MD5.b2iu(input[j]) | MD5.b2iu(input[j + 1]) << 8 | MD5.b2iu(input[j + 2]) << 16 | MD5.b2iu(input[j + 3]) << 24;
            ++i;
        }
    }

    private static long b2iu(byte b) {
        return b < 0 ? (long)(b & 0xFF) : (long)b;
    }

    private static String byte2Hex(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    static {
        digest = new byte[16];
    }
}

