/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.thread;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.common.thread.AsynchronousTask;
import org.jiucai.appframework.common.thread.TaskThreadFactory;
import org.jiucai.appframework.common.util.BaseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousCallUtil
extends BaseUtil {
    private static final ThreadLocal<AsynchronousCallUtil> threadLocal = new ThreadLocal<AsynchronousCallUtil>(){

        @Override
        protected AsynchronousCallUtil initialValue() {
            return new AsynchronousCallUtil();
        }
    };
    private int poolsize = 16;
    private Map<String, Method> modelMap;
    private List<Future<Object>> taskList;
    private static ThreadPoolExecutor threadPool;

    private AsynchronousCallUtil() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        this.modelMap = new HashMap<String, Method>();
        this.taskList = new ArrayList<Future<Object>>();
        if (threadPool == null) {
            ThreadLocal<AsynchronousCallUtil> threadLocal = AsynchronousCallUtil.threadLocal;
            synchronized (threadLocal) {
                if (threadPool == null) {
                    threadPool = new ThreadPoolExecutor(0, this.poolsize, 1000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new TaskThreadFactory());
                    threadPool.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
                }
                AsynchronousCallUtil.threadLocal.notifyAll();
            }
        }
    }

    public void setMaxThreadPoolSize(int size) {
        AsynchronousCallUtil.threadLocal.get().poolsize = size;
    }

    public static void submit(Object instance, String methName, Object ... args) throws Exception {
        threadLocal.get().submitInter(instance, methName, args);
    }

    private void submitInter(Object instance, String methName, Object ... args) throws Exception {
        Class<?> className = instance.getClass();
        Method method = this.modelMap.get(className.getName());
        if (method == null) {
            for (Method item : className.getMethods()) {
                if (!item.getName().equalsIgnoreCase(methName)) continue;
                method = item;
                this.modelMap.put(methName, method);
                break;
            }
        }
        if (method == null) {
            throw new Exception("Can not find method [" + methName + "] in class:" + className);
        }
        Future<Object> resItem = threadPool.submit(new AsynchronousTask(method, instance, args));
        this.taskList.add(resItem);
    }

    public static List<Object> get() throws Exception {
        try {
            List<Object> res;
            List<Object> list = res = threadLocal.get().getInter();
            return list;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            threadLocal.remove();
        }
    }

    private List<Object> getInter() throws Exception {
        try {
            threadPool.submit(new Thread());
            ArrayList<Object> res = new ArrayList<Object>();
            for (Future<Object> item : this.taskList) {
                try {
                    res.add(item.get());
                }
                catch (Exception e) {
                    throw new Exception("thread execute failed : " + ExceptionUtils.getFullStackTrace((Throwable)e));
                }
            }
            ArrayList<Object> arrayList = res;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.taskList.clear();
        }
    }
}

