/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.util;

import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.jiucai.appframework.common.util.LogUtil;
import org.jiucai.appframework.common.util.Logs;
import org.joda.time.DateTime;

public abstract class BaseUtil {
    protected static Logs log = LogUtil.getLog(BaseUtil.class);

    public static String convertMapValue(Object val) {
        String result = "";
        if (val instanceof Long || val instanceof Integer || val instanceof String || val instanceof Character) {
            result = String.valueOf(val);
        } else if (val instanceof Float || val instanceof Double) {
            Double d = (Double)val;
            BigDecimal bd = new BigDecimal(d);
            int scale = bd.scale();
            scale = scale > 0 ? 4 : 0;
            bd = bd.setScale(scale, 4);
            StringBuffer tempValue = new StringBuffer();
            tempValue.append(bd.toString());
            result = tempValue.toString();
        } else if (val instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)val;
            int scale = bd.scale();
            scale = scale > 0 ? 4 : 0;
            bd = bd.setScale(scale, 4);
            result = bd.toString();
        } else if (val instanceof Date) {
            Date dt = (Date)val;
            DateTime d = new DateTime(dt.getTime());
            result = d.getHourOfDay() == 0 && d.getMinuteOfHour() == 0 ? FastDateFormat.getInstance((String)"yyyy-MM-dd").format(dt) : FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(dt);
        } else if (null != val) {
            result = (String)val;
            log.warn("convertMapValue()\u65e0\u6cd5\u8f6c\u6362\u7684\u5bf9\u8c61: " + val.getClass().getName() + " , \u503c: " + val);
        }
        if (StringUtils.isBlank((String)result) || "null".equalsIgnoreCase(result)) {
            return "";
        }
        return result;
    }
}

