/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.listener;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import org.jiucai.appframework.base.listener.AbstractRequestListener;

public abstract class AbstractSecureRequestListener
extends AbstractRequestListener {
    public AbstractSecureRequestListener() {
        this.log.info("AbstractSecureRequestListener inited.");
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        super.requestInitialized(event);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        this.trimRequestParam(request);
        this.doSecureRequest(request);
    }

    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        super.requestDestroyed(event);
    }

    protected synchronized void trimRequestParam(HttpServletRequest request) {
        Enumeration paramNames = request.getParameterNames();
        if (null != paramNames) {
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                String[] paramValues = request.getParameterValues(paramName);
                if (null == paramValues || paramValues.length <= 0) continue;
                ArrayList<String> tempValues = new ArrayList<String>();
                for (int i = 0; i < paramValues.length; ++i) {
                    if (null == paramValues[i]) continue;
                    String paramValue = paramValues[i].trim();
                    tempValues.add(paramValue);
                }
                if (paramValues.length == 1) {
                    request.setAttribute(this.getReqPrefix() + paramName, tempValues.get(0));
                    continue;
                }
                request.setAttribute(this.getReqPrefix() + paramName, tempValues);
            }
        }
    }

    public abstract void doSecureRequest(HttpServletRequest var1);

    public abstract String getReqPrefix();
}

