/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.mail;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailException;
import org.jiucai.appframework.base.mail.ICallBack;
import org.jiucai.appframework.base.mail.MailSender;

public class MailTask
implements ICallBack,
Runnable {
    public static final String SEND_ASYNC = "asynchronous";
    public static final String SEND_SYNC = "synchronized";
    protected Log log = LogFactory.getLog(this.getClass());
    private MailSender sender;
    private ICallBack callBack;
    private String sendType;
    private String result;

    public MailTask() {
    }

    public MailTask(MailSender sender) {
        this.sender = sender;
    }

    public String send() throws EmailException {
        this.log.debug((Object)("send() called ,thread name: " + Thread.currentThread().getName()));
        if (null == this.sendType) {
            this.sendType = SEND_SYNC;
        }
        if (SEND_ASYNC.equals(this.sendType)) {
            Thread thread = new Thread(this);
            thread.start();
        } else if (SEND_SYNC.equals(this.sendType)) {
            this.result = this.sender.send();
        } else {
            System.err.println("Error sendType. ");
        }
        return this.result;
    }

    @Override
    public void execute(Object ... objects) {
        this.result = (String)objects[0];
        this.log.debug((Object)("execute called ,thread name: " + Thread.currentThread().getName() + " , result: " + this.result));
        Thread.interrupted();
    }

    @Override
    public void run() {
        if (null == this.callBack) {
            this.sender.setCallBack(this);
        } else {
            this.sender.setCallBack(this.callBack);
        }
        try {
            if (!SEND_ASYNC.equals(this.sendType)) {
                this.result = "Mail SendType is not asynchronous , Thread canceled. ";
                throw new EmailException(this.result);
            }
            this.result = this.sender.send();
        }
        catch (EmailException e) {
            this.result = ExceptionUtils.getRootCauseMessage((Throwable)e);
            this.log.error((Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public String getResult() {
        return this.result;
    }

    public ICallBack getCallBack() {
        return this.callBack;
    }

    public void setCallBack(ICallBack callBack) {
        this.callBack = callBack;
    }

    public String getSendType() {
        return this.sendType;
    }

    public void setSendType(String sendType) {
        this.sendType = sendType;
    }
}

