/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.encrypt;

import org.apache.commons.lang.StringUtils;
import org.jiucai.appframework.common.encode.Base64;
import org.jiucai.appframework.common.encode.MD5;
import org.jiucai.appframework.common.encrypt.XXTEA;

public class EncryptUtil {
    private static final String charsetName = "UTF-8";

    public static synchronized String encrypt(String msg, String key) throws Exception {
        return MD5.encode(EncryptUtil.encode(msg, key));
    }

    public static synchronized String encode(String msg, String key) throws Exception {
        String encodeMsg = "";
        if (StringUtils.isEmpty((String)msg) || StringUtils.isEmpty((String)key)) {
            return encodeMsg;
        }
        byte[] data = XXTEA.encrypt(msg.getBytes(charsetName), key.getBytes(charsetName));
        encodeMsg = Base64.encode(data);
        return encodeMsg;
    }

    public static synchronized String decode(String encodeMsg, String key) throws Exception {
        String decodeMsg = "";
        if (StringUtils.isEmpty((String)encodeMsg) || StringUtils.isEmpty((String)key)) {
            return decodeMsg;
        }
        byte[] data = Base64.decode(encodeMsg);
        data = XXTEA.decrypt(data, key.getBytes(charsetName));
        decodeMsg = new String(data, charsetName);
        return decodeMsg;
    }

    public static String byte2Hex(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hex2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

